/*
 * Decompiled with CFR 0.152.
 */
package io.konig.etl.aws;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.commons.io.IOUtils;

public class PrepareToLoadTargetTable
implements Processor {
    public void process(Exchange exchange) throws Exception {
        String dmlScript = (String)exchange.getIn().getHeader("dmlScript", String.class);
        String currDate = this.currDate();
        String dml = this.fileToString(new File(dmlScript + ".sql")).replace("\"{modified}\"", "TIMESTAMP('" + currDate + "')");
        exchange.getOut().setBody((Object)dml);
        exchange.getIn().setHeader("modified", (Object)currDate);
        exchange.getOut().setHeaders(exchange.getIn().getHeaders());
    }

    private String currDate() {
        Calendar cal = Calendar.getInstance();
        String DATE_FORMAT_NOW = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
        return sdf.format(cal.getTime());
    }

    private String fileToString(File dmlFile) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(dmlFile);){
            String string = IOUtils.toString((InputStream)inputStream);
            return string;
        }
    }
}

