/*
 * Decompiled with CFR 0.152.
 */
package io.konig.etl.aws;

import com.amazonaws.services.s3.event.S3EventNotification;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;

public class PrepareToLoadStagingTable
implements Processor {
    public void process(Exchange exchange) throws Exception {
        String body = (String)exchange.getIn().getBody(String.class);
        if (body != null && !body.equals("")) {
            String sourceTable = (String)exchange.getIn().getHeader("sourceTable", String.class);
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            JsonNode rootNode = objectMapper.readTree(body);
            JsonNode messageNode = rootNode.path("Message");
            S3EventNotification notification = (S3EventNotification)objectMapper.readValue(messageNode.asText(), S3EventNotification.class);
            String bucketName = "";
            String fileName = "";
            for (S3EventNotification.S3EventNotificationRecord record : notification.getRecords()) {
                bucketName = record.getS3().getBucket().getName().toLowerCase();
                fileName = record.getS3().getObject().getKey();
                exchange.getOut().setBody((Object)("LOAD DATA FROM S3 's3-" + record.getAwsRegion() + "://" + bucketName + "/" + fileName + "' INTO TABLE " + sourceTable + " FIELDS TERMINATED BY ',' LINES TERMINATED BY '\\n'; "));
                exchange.getOut().setHeaders(exchange.getIn().getHeaders());
                exchange.getOut().setHeader("fileName", (Object)fileName);
                exchange.getOut().setHeader("bucketName", (Object)bucketName);
            }
        }
    }
}

