/*
 * Decompiled with CFR 0.152.
 */
package io.konig.etl.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.sqs.AmazonSQSClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@SpringBootApplication
@RestController
@ImportResource(value={"classpath:app-config.xml"})
@PropertySource(value={"file:camel-routes-config.properties"})
public class CamelEtlRouteController {
    @Value(value="${aws.accessKey}")
    private String ACCESS_KEY;
    @Value(value="${aws.secretKey}")
    private String SECRET_KEY;

    public static void main(String[] args) throws Exception {
        SpringApplication.run(CamelEtlRouteController.class, (String[])args);
    }

    @Bean
    AmazonSQSClient sqsClient() {
        BasicAWSCredentials credentials = new BasicAWSCredentials(this.ACCESS_KEY, this.SECRET_KEY);
        return new AmazonSQSClient((AWSCredentials)credentials);
    }

    @Bean
    AmazonS3Client s3Client() {
        BasicAWSCredentials credentials = new BasicAWSCredentials(this.ACCESS_KEY, this.SECRET_KEY);
        return new AmazonS3Client((AWSCredentials)credentials);
    }

    @RequestMapping(value={"/health"})
    @ResponseBody
    public String health() {
        return "200 OK";
    }
}

