/*
 * Decompiled with CFR 0.152.
 */
package io.konig.etl;

import io.konig.etl.ETLController;
import io.konig.etl.ETLDatasource;
import io.konig.etl.ETLException;
import io.konig.etl.MockETLDatasource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@SpringBootApplication
@RestController
public class ETLControllerEndPoint {
    public Logger logger = LoggerFactory.getLogger(ETLControllerEndPoint.class);

    @RequestMapping(value={"/etl"})
    @ResponseBody
    public String runETLController(@RequestParam(value="inObjectId") String inObjectId, @RequestParam(value="outObjectId") String outObjectId) {
        this.logger.info("Input Object Id ::" + inObjectId + ", Output Object Id :: " + outObjectId);
        ETLController etlController = new ETLController((ETLDatasource)new MockETLDatasource());
        String jsonFile = "etlRequest.json";
        try {
            etlController.run(jsonFile, inObjectId, outObjectId);
        }
        catch (ETLException e) {
            this.logger.error("Exception occured in ETLControllerEndPoint. ", (Throwable)e);
            return "Error occured in ETL Process " + e.getMessage();
        }
        return "ETL Process completed";
    }

    public static void main(String[] args) {
        SpringApplication.run(ETLControllerEndPoint.class, (String[])args);
    }
}

