/*
 * Decompiled with CFR 0.152.
 */
package io.konig.etl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.konig.etl.ETLDatasource;
import io.konig.etl.ETLException;
import io.konig.etl.ETLProcess;
import io.konig.etl.ETLRequest;
import io.konig.etl.ExportRequest;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ETLController {
    public Logger logger = LoggerFactory.getLogger(ETLController.class);
    ETLDatasource etlDatasource;

    public ETLDatasource getEtlDatasource() {
        return this.etlDatasource;
    }

    public void setEtlDatasource(ETLDatasource etlDatasource) {
        this.etlDatasource = etlDatasource;
    }

    public ETLController(ETLDatasource etlDatasource) {
        this.etlDatasource = etlDatasource;
    }

    public void run(String jsonFile, String inObjectId, String outObjectId) throws ETLException {
        this.logger.info("Entered ETLController run method");
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(jsonFile);){
            ObjectMapper objectMapper = new ObjectMapper();
            ETLRequest request = (ETLRequest)objectMapper.readValue(is, ETLRequest.class);
            request.setDatasource(this.etlDatasource);
            request.setObjectId(inObjectId);
            ExportRequest exportRequest = request.getExportRequest();
            exportRequest.setObjectId(outObjectId);
            request.setExportRequest(exportRequest);
            ETLProcess process = new ETLProcess();
            process.run(request);
        }
        catch (IOException e) {
            throw new ETLException((Throwable)e);
        }
        this.logger.info("Exiting ETLController run method");
    }
}

