package io.konig.etl;

/*
 * #%L
 * Konig ETL
 * %%
 * Copyright (C) 2015 - 2018 Gregory McFall
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */



import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockETLDatasource implements ETLDatasource {

	public static Logger logger=LoggerFactory.getLogger(MockETLDatasource.class);
	@Override
	public void transform(String sql) throws ETLException {
		logger.info("Transform :: "+sql);
		
	}

	@Override
	public void createTmpTable(String sql) throws ETLException {
		logger.info("CreateTmpTable :: "+sql);
		
	}

	@Override
	public void deleteTmpTable(String tableName) throws ETLException {
		logger.info("DeleteTmpTable :: "+tableName);
		
	}

	@Override
	public void loadTmpTable(String tableName, String bucketName, String objectId) throws ETLException {
		logger.info("LoadTmpTable :: tableName: "+tableName+", objectId: "+objectId);
		
	}

	@Override
	public void export(ExportRequest request) throws ETLException {
		logger.info("Export :: request: "+request.toString());
	}

}
