/*
 * Decompiled with CFR 0.152.
 */
package io.konig.dao.core;

import io.konig.dao.core.BoundaryCondition;
import io.konig.dao.core.BoundaryPoint;
import io.konig.dao.core.Chart;
import io.konig.dao.core.ChartCategories;
import io.konig.dao.core.ChartDataset;
import io.konig.dao.core.ChartFactory;
import io.konig.dao.core.ChartSeriesFactory;
import io.konig.dao.core.ChartSeriesRequest;
import io.konig.dao.core.DaoException;
import io.konig.dao.core.DataRange;
import io.konig.dao.core.DateTimeCategories;
import io.konig.dao.core.FieldPath;
import io.konig.dao.core.LabelCategories;
import io.konig.dao.core.ShapeQuery;
import io.konig.sql.runtime.EntityStructure;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.XMLSchema;

public class SimpleChartFactory
implements ChartFactory {
    private static final String MIN_INCLUSIVE = ".minInclusive";
    private static final String MIN_EXCLUSIVE = ".minExclusive";
    private static final String MAX_INCLUSIVE = ".maxInclusive";
    private static final String MAX_EXCLUSIVE = ".maxExclusive";
    private static final String INTERVALSTART = ".intervalStart";
    private static final String X_AXIS = "xAxis";
    private static final String Y_AXIS = "yAxis";
    private static final String VIEW = ".view";
    private static final int OFFSET = ".minInclusive".length();
    private ChartSeriesFactory seriesFactory;

    public SimpleChartFactory(ChartSeriesFactory seriesFactory) {
        this.seriesFactory = seriesFactory;
    }

    @Override
    public Chart createChart(ShapeQuery query, EntityStructure struct) throws DaoException {
        String value;
        switch (value = query.getParameters().get(VIEW)) {
            case "vnd.pearson.chart.fusioncharts.msline": {
                return this.createMultiSeriesLineChart(query, struct);
            }
            case "vnd.pearson.chart.fusioncharts.map": {
                return this.createMapChart(query, struct);
            }
            case "vnd.pearson.chart.fusioncharts.bar": {
                return this.createBarChart(query, struct);
            }
            case "vnd.pearson.chart.fusioncharts.pie": {
                return this.createPieChart(query, struct);
            }
        }
        throw new DaoException("Invalid media type for charts: " + value);
    }

    public Chart createMultiSeriesLineChart(ShapeQuery query, EntityStructure struct) throws DaoException {
        String xAxis = query.getParameters().get(X_AXIS);
        Chart chart = new Chart();
        chart.setCaption(struct.getComment());
        if (xAxis.endsWith(INTERVALSTART)) {
            chart.setCategories(this.createCategories(query, struct));
        } else {
            chart.setCategories(new LabelCategories());
        }
        chart.setDataset(this.createChartDataset(query, struct, chart.getCategories()));
        return chart;
    }

    public Chart createMapChart(ShapeQuery query, EntityStructure struct) throws DaoException {
        Chart chart = new Chart();
        chart.setCaption(struct.getComment());
        chart.setDataset(this.createChartDataset(query, struct, null));
        return chart;
    }

    public Chart createBarChart(ShapeQuery query, EntityStructure struct) throws DaoException {
        String xAxis = query.getParameters().get(X_AXIS);
        Chart chart = new Chart();
        chart.setCaption(struct.getComment());
        if (xAxis.endsWith(INTERVALSTART)) {
            chart.setCategories(this.createCategories(query, struct));
        } else {
            chart.setCategories(new LabelCategories());
        }
        chart.setDataset(this.createChartDataset(query, struct, chart.getCategories()));
        return chart;
    }

    public Chart createPieChart(ShapeQuery query, EntityStructure struct) throws DaoException {
        String xAxis = query.getParameters().get(X_AXIS);
        Chart chart = new Chart();
        chart.setCaption(struct.getComment());
        chart.setDataset(this.createChartDataset(query, struct, null));
        return chart;
    }

    private ChartDataset createChartDataset(ShapeQuery query, EntityStructure struct, ChartCategories chartCategories) throws DaoException {
        String xAxis = query.getParameters().get(X_AXIS);
        String yAxis = query.getParameters().get(Y_AXIS);
        ChartDataset dataset = new ChartDataset();
        FieldPath measure = FieldPath.createFieldPath(yAxis, struct);
        if (measure == null) {
            throw new DaoException("measure path not found in Shape: " + query.getShapeId());
        }
        FieldPath dimension = FieldPath.createFieldPath(xAxis, struct);
        if (dimension == null) {
            throw new DaoException("dimension path not found in Shape:  " + query.getShapeId());
        }
        ChartSeriesRequest request = ChartSeriesRequest.builder().setDimension(dimension).setMeasure(measure).setQuery(query).setStruct(struct).build();
        dataset.add(this.seriesFactory.createChartSeries(request));
        return dataset;
    }

    private ChartCategories createCategories(ShapeQuery query, EntityStructure struct) throws DaoException {
        DataRange range = this.dataRange(query, struct);
        DateTime start = this.toDateTime(range, range.getStartPoint());
        DateTime end = this.toDateTime(range, range.getEndPoint());
        Period duration = this.toPeriod(query);
        return new DateTimeCategories(range, start, end, duration);
    }

    private Period toPeriod(ShapeQuery query) throws DaoException {
        String value = query.getParameters().get("timeInterval.durationUnit");
        if (value == null) {
            throw new DaoException("durationUnit is not defined");
        }
        switch (value = value.toLowerCase()) {
            case "second": {
                return Period.seconds((int)1);
            }
            case "hour": {
                return Period.hours((int)1);
            }
            case "day": {
                return Period.days((int)1);
            }
            case "week": {
                return Period.weeks((int)1);
            }
            case "month": {
                return Period.months((int)1);
            }
            case "quarter": {
                return Period.months((int)3);
            }
            case "year": {
                return Period.years((int)1);
            }
        }
        throw new DaoException("Invalid durationUnit: " + value);
    }

    private DateTime toDateTime(DataRange range, BoundaryPoint point) throws DaoException {
        String value = point.getValue();
        URI fieldType = range.getPath().lastField().getFieldType();
        if (fieldType.equals((Object)XMLSchema.DATE) || fieldType.equals((Object)XMLSchema.DATETIME)) {
            return new DateTime((Object)value).toLocalDateTime().toDateTime(DateTimeZone.UTC);
        }
        throw new DaoException("Unsupported data type: " + fieldType.stringValue());
    }

    private DataRange dataRange(ShapeQuery query, EntityStructure struct) throws DaoException {
        String path = null;
        BoundaryPoint start = null;
        BoundaryPoint end = null;
        for (Map.Entry<String, String> e : query.getParameters().entrySet()) {
            String key = e.getKey();
            String value = e.getValue();
            if (key.endsWith(MIN_INCLUSIVE)) {
                path = this.path(key, path);
                start = new BoundaryPoint(value, BoundaryCondition.INCLUSIVE);
                continue;
            }
            if (key.endsWith(MIN_EXCLUSIVE)) {
                path = this.path(key, path);
                start = new BoundaryPoint(value, BoundaryCondition.EXCLUSIVE);
                continue;
            }
            if (key.endsWith(MAX_INCLUSIVE)) {
                path = this.path(key, path);
                end = new BoundaryPoint(value, BoundaryCondition.INCLUSIVE);
                continue;
            }
            if (!key.endsWith(MAX_EXCLUSIVE)) continue;
            path = this.path(key, path);
            end = new BoundaryPoint(value, BoundaryCondition.EXCLUSIVE);
        }
        if (start != null && end != null && path != null) {
            FieldPath fieldPath = FieldPath.createFieldPath(path, struct);
            return new DataRange(fieldPath, start, end);
        }
        return null;
    }

    private String path(String paramName, String path) throws DaoException {
        String result = paramName.substring(0, paramName.length() - OFFSET);
        if (path != null && !path.equals(result)) {
            throw new DaoException("Multiple ranges not supported");
        }
        return result;
    }
}

