/*
 * Decompiled with CFR 0.152.
 */
package io.konig.dao.core;

import io.konig.dao.core.ConstraintOperator;
import io.konig.dao.core.DataFilter;
import io.konig.dao.core.ShapeQuery;

public class PredicateConstraint
implements DataFilter {
    private String propertyName;
    private ConstraintOperator operator;
    private Object value;

    public PredicateConstraint(String propertyName, ConstraintOperator operator, Object value) {
        this.propertyName = propertyName;
        this.operator = operator;
        this.value = value;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public ConstraintOperator getOperator() {
        return this.operator;
    }

    public Object getValue() {
        return this.value;
    }

    public static class Builder {
        private ShapeQuery.Builder queryBuilder;
        private String propertyName;
        private ConstraintOperator operator;
        private Object value;

        public Builder(ShapeQuery.Builder queryBuilder) {
            this.queryBuilder = queryBuilder;
        }

        public Builder setPropertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public Builder setOperator(ConstraintOperator operator) {
            this.operator = operator;
            return this;
        }

        public Builder setValue(Object value) {
            this.value = value;
            return this;
        }

        public ShapeQuery.Builder endPredicateConstraint() {
            this.queryBuilder.addFilter(new PredicateConstraint(this.propertyName, this.operator, this.value));
            return this.queryBuilder;
        }
    }
}

