/*
 * Decompiled with CFR 0.152.
 */
package io.konig.dao.core;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.cloud.bigquery.FieldValue;
import io.konig.dao.core.Chart;
import io.konig.dao.core.ChartCategories;
import io.konig.dao.core.ChartDataset;
import io.konig.dao.core.ChartSeries;
import io.konig.dao.core.ChartWriter;
import io.konig.dao.core.Formatter;
import io.konig.dao.core.LabelCategories;
import io.konig.dao.core.OrderedPair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class FusionBarChartWriter
implements ChartWriter {
    private JsonGenerator json;
    private Formatter categoryFormatter;
    private Formatter dataFormatter;

    public FusionBarChartWriter(JsonGenerator json, Formatter categoryFormatter, Formatter dataFormatter) {
        this.json = json;
        this.categoryFormatter = categoryFormatter;
        this.dataFormatter = dataFormatter;
    }

    @Override
    public void writeChart(Chart chart) throws IOException {
        this.json.writeStartObject();
        if (chart.getCaption() != null) {
            this.json.writeStringField("caption", chart.getCaption());
        }
        if (chart.getxAxisLabel() != null) {
            this.json.writeStringField("xAxisName", chart.getxAxisLabel());
        }
        if (chart.getCategories().iterator() == null) {
            chart.setCategories(this.createCategories(chart));
        }
        this.writeCategories(chart);
        this.writeDataset(chart);
        this.json.writeEndObject();
        this.json.flush();
    }

    private ChartCategories createCategories(Chart chart) throws IOException {
        ChartDataset dataset = chart.getDataset();
        ArrayList<String> labels = new ArrayList<String>();
        LabelCategories categories = (LabelCategories)chart.getCategories();
        Iterator<ChartSeries> iterator = dataset.getSeries().iterator();
        if (iterator.hasNext()) {
            ChartSeries series = iterator.next();
            Iterator<OrderedPair> pairSequence = series.iterator();
            while (pairSequence.hasNext()) {
                OrderedPair pair = pairSequence.next();
                Object x = pair.getX();
                if (x instanceof String) {
                    labels.add(x.toString());
                    continue;
                }
                if (!(x instanceof ArrayList)) continue;
                ArrayList fieldValue = (ArrayList)x;
                labels.add(((FieldValue)fieldValue.get(1)).getStringValue());
            }
        }
        categories.setLabels(labels);
        return categories;
    }

    private void writeDataset(Chart chart) throws IOException {
        ChartDataset dataset = chart.getDataset();
        this.json.writeArrayFieldStart("dataset");
        for (ChartSeries series : dataset.getSeries()) {
            this.json.writeStartObject();
            if (series.getNextPageToken() != null) {
                this.json.writeStringField("cursor", series.getNextPageToken());
            }
            if (series.getTitle() != null) {
                this.json.writeStringField("title", series.getTitle());
            }
            this.json.writeArrayFieldStart("data");
            Iterator<OrderedPair> pairSequence = series.iterator();
            Iterator<? extends Object> categorySequence = chart.getCategories().iterator();
            while (categorySequence.hasNext()) {
                Object category = categorySequence.next();
                pairSequence = series.iterator();
                this.json.writeStartObject();
                this.json.writeStringField("value", this.dataFormatter.format("0"));
                while (pairSequence.hasNext()) {
                    OrderedPair pair = pairSequence.next();
                    Object x = pair.getX();
                    Object dimension = null;
                    String dimensionId = "";
                    if (x instanceof String) {
                        dimension = x.toString();
                    } else if (x instanceof ArrayList) {
                        ArrayList fieldValue = (ArrayList)x;
                        dimensionId = ((FieldValue)fieldValue.get(0)).getStringValue();
                        dimension = ((FieldValue)fieldValue.get(1)).getStringValue();
                    } else {
                        dimension = x;
                    }
                    if (!category.equals(dimension)) continue;
                    Object y = pair.getY();
                    String value = this.dataFormatter.format(y);
                    this.json.writeStringField("value", value);
                    this.json.writeStringField("label", this.categoryFormatter.format(dimension));
                    this.json.writeStringField("link", "j-drilldown-" + dimensionId + "|" + dimension.toString() + "|School");
                    break;
                }
                this.json.writeEndObject();
            }
            this.json.writeEndArray();
            this.json.writeEndObject();
        }
        this.json.writeEndArray();
    }

    private void writeCategories(Chart chart) throws IOException {
        Iterator<? extends Object> sequence = chart.getCategories().iterator();
        this.json.writeArrayFieldStart("categories");
        this.json.writeStartObject();
        this.json.writeArrayFieldStart("category");
        while (sequence.hasNext()) {
            this.json.writeStartObject();
            String value = this.categoryFormatter.format(sequence.next());
            this.json.writeStringField("label", value);
            this.json.writeEndObject();
        }
        this.json.writeEndArray();
        this.json.writeEndObject();
        this.json.writeEndArray();
    }
}

