/*
 * Decompiled with CFR 0.152.
 */
package io.konig.dao.core;

import java.util.Iterator;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class DateTimeIterator
implements Iterator<DateTime> {
    private DateTime end;
    private ReadablePeriod interval;
    private DateTime current;

    public DateTimeIterator(DateTime start, DateTime end, ReadablePeriod interval) {
        this.current = start;
        this.end = end;
        this.interval = interval;
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public DateTime next() {
        DateTime result = this.current;
        if (this.current != null) {
            this.current = this.current.plus(this.interval);
            if (this.current.compareTo((ReadableInstant)this.end) > 0) {
                this.current = null;
            }
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

