/*
 * Decompiled with CFR 0.152.
 */
package io.konig.dao.core;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.cloud.bigquery.FieldValue;
import io.konig.dao.core.Chart;
import io.konig.dao.core.ChartDataset;
import io.konig.dao.core.ChartSeries;
import io.konig.dao.core.ChartWriter;
import io.konig.dao.core.Formatter;
import io.konig.dao.core.OrderedPair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class FusionPieChartWriter
implements ChartWriter {
    private JsonGenerator json;
    private Formatter dataFormatter;

    public FusionPieChartWriter(JsonGenerator json, Formatter dataFormatter) {
        this.json = json;
        this.dataFormatter = dataFormatter;
    }

    @Override
    public void writeChart(Chart chart) throws IOException {
        this.json.writeStartObject();
        if (chart.getCaption() != null) {
            this.json.writeStringField("caption", chart.getCaption());
        }
        this.writeDataset(chart);
        this.json.writeEndObject();
        this.json.flush();
    }

    private void writeDataset(Chart chart) throws IOException {
        ChartDataset dataset = chart.getDataset();
        this.json.writeArrayFieldStart("data");
        for (ChartSeries series : dataset.getSeries()) {
            Iterator<OrderedPair> pairSequence = series.iterator();
            while (pairSequence.hasNext()) {
                OrderedPair pair = pairSequence.next();
                Object x = pair.getX();
                Object y = pair.getY();
                Object dimension = "";
                String dimensionId = "";
                if (x instanceof String) {
                    dimension = x.toString();
                } else if (x instanceof ArrayList) {
                    ArrayList fieldValue = (ArrayList)x;
                    dimensionId = ((FieldValue)fieldValue.get(0)).getStringValue();
                    dimension = ((FieldValue)fieldValue.get(1)).getStringValue();
                } else {
                    dimension = x;
                }
                String value = this.dataFormatter.format(y);
                this.json.writeStartObject();
                this.json.writeStringField("value", value);
                this.json.writeStringField("label", dimension.toString());
                this.json.writeStringField("link", "j-drilldown-" + dimensionId + "|" + dimension.toString() + "|Grade");
                this.json.writeEndObject();
            }
            this.json.writeEndArray();
        }
    }
}

