/*
 * Decompiled with CFR 0.152.
 */
package io.konig.dao.core;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import com.google.cloud.bigquery.FieldValue;
import io.konig.dao.core.Chart;
import io.konig.dao.core.ChartDataset;
import io.konig.dao.core.ChartGeoLocationMapping;
import io.konig.dao.core.ChartSeries;
import io.konig.dao.core.ChartWriter;
import io.konig.dao.core.Formatter;
import io.konig.dao.core.OrderedPair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class FusionMapChartWriter
implements ChartWriter {
    private JsonGenerator json;
    private Formatter dataFormatter;
    private ChartGeoLocationMapping mapping = null;

    public FusionMapChartWriter(JsonGenerator json, Formatter dataFormatter) {
        this.json = json;
        this.dataFormatter = dataFormatter;
        this.mapping = (ChartGeoLocationMapping)MemcacheServiceFactory.getMemcacheService().get((Object)"FusionIdMapping");
    }

    @Override
    public void writeChart(Chart chart) throws IOException {
        this.json.writeStartObject();
        if (chart.getCaption() != null) {
            this.json.writeStringField("caption", chart.getCaption());
        }
        if (chart.getxAxisLabel() != null) {
            this.json.writeStringField("xAxisName", chart.getxAxisLabel());
        }
        this.writeDataset(chart);
        this.json.writeEndObject();
        this.json.flush();
    }

    private void writeDataset(Chart chart) throws IOException {
        ChartDataset dataset = chart.getDataset();
        this.json.writeArrayFieldStart("data");
        String containedInPlace = "";
        for (ChartSeries series : dataset.getSeries()) {
            Iterator<OrderedPair> pairSequence = series.iterator();
            while (pairSequence.hasNext()) {
                OrderedPair pair = pairSequence.next();
                Object x = pair.getX();
                Object y = pair.getY();
                String value = this.dataFormatter.format(y);
                String mapId = "";
                if (x instanceof String) {
                    mapId = x.toString();
                } else if (x instanceof ArrayList) {
                    ArrayList fieldValue = (ArrayList)x;
                    mapId = ((FieldValue)fieldValue.get(0)).getStringValue();
                }
                try {
                    containedInPlace = this.mapping.getContainedInPlace(mapId);
                    this.json.writeStartObject();
                    this.json.writeStringField("id", this.mapping.getFusionId(mapId));
                    this.json.writeStringField("value", value);
                    this.json.writeStringField("showLabel", "1");
                    this.json.writeStringField("fontBold", "1");
                    this.json.writeStringField("useHoverColor", "1");
                    this.json.writeStringField("showToolTip", "1");
                    this.json.writeStringField("FontColor", "#000000");
                    this.json.writeStringField("link", "j-drilldown-" + mapId + "|" + this.mapping.getName(mapId) + "|" + this.mapping.getType(mapId));
                    this.json.writeEndObject();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.json.writeEndArray();
        if (containedInPlace != null && !containedInPlace.equals("")) {
            this.json.writeStringField("type", this.mapping.getName(containedInPlace).replaceAll(" ", "").toLowerCase());
        }
    }
}

