/*
 * Decompiled with CFR 0.152.
 */
package io.konig.dao.core;

import java.util.StringTokenizer;

public class ChartKey {
    private static final String[] LIBRARIES = new String[]{"fusioncharts"};
    private String libraryName;
    private String chartType;

    private ChartKey(String libraryName, String chartType) {
        this.libraryName = libraryName;
        this.chartType = chartType;
    }

    public static boolean isLibrary(String name) {
        String[] stringArray = LIBRARIES;
        int n = LIBRARIES.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (value.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static ChartKey fromMediaType(String mediaType) {
        int slash = mediaType.indexOf(47);
        if (slash > 0) {
            mediaType = mediaType.substring(slash + 1);
        }
        StringTokenizer tokenizer = new StringTokenizer(mediaType, ".");
        while (tokenizer.hasMoreTokens()) {
            String library = tokenizer.nextToken();
            if (!ChartKey.isLibrary(library) || !tokenizer.hasMoreTokens()) continue;
            String chartType = tokenizer.nextToken();
            return new ChartKey(library, chartType);
        }
        return null;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public String getChartType() {
        return this.chartType;
    }

    public String toString() {
        return String.valueOf(this.libraryName) + '.' + this.chartType;
    }
}

