/*
 * Decompiled with CFR 0.152.
 */
package io.konig.dao.core;

import io.konig.dao.core.CompositeDataFilter;
import io.konig.dao.core.CompositeOperator;
import io.konig.dao.core.DataFilter;
import io.konig.dao.core.PredicateConstraint;
import java.util.Map;

public class ShapeQuery {
    private String shapeId;
    private DataFilter filter;
    private String view;
    private String aggregate;
    private Long limit;
    private String xSort;
    private String ySort;
    private Long offset;
    private String cursor;
    private Map<String, String> parameters;

    public String getShapeId() {
        return this.shapeId;
    }

    public DataFilter getFilter() {
        return this.filter;
    }

    public String getView() {
        return this.view;
    }

    public String getAggregate() {
        return this.aggregate;
    }

    public Long getLimit() {
        return this.limit;
    }

    public Long getOffset() {
        return this.offset;
    }

    public String getXSort() {
        return this.xSort;
    }

    public String getYSort() {
        return this.ySort;
    }

    public String getCursor() {
        return this.cursor;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    private void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    private void setShapeId(String shapeId) {
        this.shapeId = shapeId;
    }

    private void setFilter(DataFilter filter) {
        this.filter = filter;
    }

    private void setView(String view) {
        this.view = view;
    }

    private void setAggregate(String aggregate) {
        this.aggregate = aggregate;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public void setOffset(Long offset) {
        this.offset = offset;
    }

    private void setXSort(String xSort) {
        this.xSort = xSort;
    }

    private void setYSort(String ySort) {
        this.ySort = ySort;
    }

    private void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        ShapeQuery query = new ShapeQuery();

        public Builder setShapeId(String shapeId) {
            this.query.setShapeId(shapeId);
            return this;
        }

        public Builder setView(String view) {
            this.query.setView(view);
            return this;
        }

        public Builder setAggregate(String aggregate) {
            this.query.setAggregate(aggregate);
            return this;
        }

        public Builder setXSort(String xSort) {
            this.query.setXSort(xSort);
            return this;
        }

        public Builder setYSort(String ySort) {
            this.query.setYSort(ySort);
            return this;
        }

        public Builder setLimit(Long limit) {
            this.query.setLimit(limit);
            return this;
        }

        public Builder setOffset(Long offset) {
            this.query.setOffset(offset);
            return this;
        }

        public Builder setCursor(String cursor) {
            this.query.setCursor(cursor);
            return this;
        }

        public Builder setParameters(Map<String, String> parameters) {
            this.query.setParameters(parameters);
            return this;
        }

        public ShapeQuery build() {
            return this.query;
        }

        public PredicateConstraint.Builder beginPredicateConstraint() {
            return new PredicateConstraint.Builder(this);
        }

        public void addFilter(DataFilter filter) {
            DataFilter shapeFilter = this.query.getFilter();
            if (shapeFilter == null) {
                shapeFilter = filter;
            } else if (shapeFilter instanceof CompositeDataFilter) {
                CompositeDataFilter composite = (CompositeDataFilter)shapeFilter;
                composite.add(filter);
            } else {
                CompositeDataFilter composite = new CompositeDataFilter(CompositeOperator.AND);
                composite.add(shapeFilter);
                composite.add(filter);
                shapeFilter = composite;
            }
            this.query.setFilter(shapeFilter);
        }
    }
}

