/*
 * Decompiled with CFR 0.152.
 */
package io.konig.dao.core;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.konig.dao.core.Chart;
import io.konig.dao.core.ChartCategories;
import io.konig.dao.core.ChartWriter;
import io.konig.dao.core.DaoException;
import io.konig.dao.core.DateTimeCategories;
import io.konig.dao.core.Formatter;
import io.konig.dao.core.FusionBarChartWriter;
import io.konig.dao.core.FusionMapChartWriter;
import io.konig.dao.core.FusionMultiLineChartWriter;
import io.konig.dao.core.FusionPieChartWriter;
import io.konig.dao.core.LabelCategories;
import io.konig.dao.core.SimpleFormatter;
import io.konig.dao.core.TemporalFormatter;
import java.io.IOException;
import java.io.Writer;
import org.joda.time.Period;
import org.joda.time.format.DateTimeFormat;

public class ChartWriterFactory {
    private static final String HOUR = "HH:00 on MMM dd, yyyy";
    private static final String DATE = "MMM dd, yyyy";
    private static final String MONTH = "MMM, yyyy";
    private static final String YEAR = "yyyy";

    public ChartWriter createChartWriter(Chart chart, Writer out) throws DaoException {
        switch (chart.getKey().toString()) {
            case "fusioncharts.msline": {
                return new FusionMultiLineChartWriter(this.jsonGenerator(out), this.categoryFormatter(chart), this.dataFormatter(chart));
            }
            case "fusioncharts.map": {
                return new FusionMapChartWriter(this.jsonGenerator(out), this.dataFormatter(chart));
            }
            case "fusioncharts.pie": {
                return new FusionPieChartWriter(this.jsonGenerator(out), this.dataFormatter(chart));
            }
            case "fusioncharts.bar": {
                return new FusionBarChartWriter(this.jsonGenerator(out), this.categoryFormatter(chart), this.dataFormatter(chart));
            }
        }
        throw new DaoException("Unsupported ChartWriter: " + chart.getKey().toString());
    }

    private Formatter dataFormatter(Chart chart) {
        return new SimpleFormatter();
    }

    private JsonGenerator jsonGenerator(Writer out) throws DaoException {
        JsonFactory factory = new JsonFactory();
        try {
            return factory.createGenerator(out);
        }
        catch (IOException e) {
            throw new DaoException(e);
        }
    }

    private Formatter categoryFormatter(Chart chart) {
        ChartCategories categories = chart.getCategories();
        if (categories instanceof DateTimeCategories) {
            String pattern = null;
            DateTimeCategories c = (DateTimeCategories)categories;
            Period period = c.getInterval();
            if (period.getHours() > 0) {
                pattern = HOUR;
            } else if (period.getDays() > 0) {
                pattern = DATE;
            } else if (period.getMonths() > 0) {
                pattern = MONTH;
            } else if (period.getYears() > 0) {
                pattern = YEAR;
            } else {
                throw new RuntimeException("Unsupported period: " + period.toString());
            }
            return new TemporalFormatter(DateTimeFormat.forPattern((String)pattern));
        }
        if (categories instanceof LabelCategories) {
            return new Formatter(){

                @Override
                public String format(Object value) {
                    return (String)value;
                }
            };
        }
        throw new RuntimeException("Category type not supported");
    }
}

