/*
 * Decompiled with CFR 0.152.
 */
package io.konig.dao.core;

import io.konig.dao.core.DaoException;
import io.konig.sql.runtime.EntityStructure;
import io.konig.sql.runtime.FieldInfo;
import io.konig.sql.runtime.Stereotype;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class FieldPath
extends ArrayList<FieldInfo> {
    private static final long serialVersionUID = 1L;
    private String stringValue;

    public FieldPath(String stringValue) {
        this.stringValue = stringValue;
    }

    public String stringValue() {
        if (this.stringValue == null) {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (FieldInfo field : this) {
                if (first) {
                    first = false;
                } else {
                    builder.append('.');
                }
                builder.append(field.getName());
            }
            this.stringValue = builder.toString();
        }
        return this.stringValue;
    }

    @Override
    public String toString() {
        return this.stringValue();
    }

    public FieldInfo pop() {
        return this.isEmpty() ? null : (FieldInfo)this.remove(this.size() - 1);
    }

    public FieldInfo lastField() {
        return this.isEmpty() ? null : (FieldInfo)this.get(this.size() - 1);
    }

    public static FieldPath createFieldPath(String path, EntityStructure struct) throws DaoException {
        FieldPath result = new FieldPath(path);
        StringTokenizer tokenizer = new StringTokenizer(path, ".");
        while (tokenizer.hasMoreTokens()) {
            FieldInfo field;
            String fieldName = tokenizer.nextToken();
            FieldInfo fieldInfo = field = struct == null ? null : struct.findFieldByName(fieldName);
            if (field == null) {
                throw new DaoException("Field not found: " + path);
            }
            result.add(field);
            struct = field.getStruct();
        }
        return result;
    }

    public static FieldPath measurePath(EntityStructure struct) {
        FieldPath result = new FieldPath(null);
        return FieldPath.measurePath(result, struct) ? result : null;
    }

    private static boolean measurePath(FieldPath result, EntityStructure struct) {
        for (FieldInfo field : struct.getFields()) {
            if (!Stereotype.MEASURE.equals((Object)field.getStereotype())) continue;
            result.add(field);
            return true;
        }
        for (FieldInfo field : struct.getFields()) {
            EntityStructure child = field.getStruct();
            if (child == null) continue;
            result.add(field);
            if (FieldPath.measurePath(result, child)) {
                return true;
            }
            result.pop();
        }
        return false;
    }
}

