/*
 * Decompiled with CFR 0.152.
 */
package io.konig.content;

import io.konig.content.AssetMetadata;
import io.konig.content.ContentSystemUtil;

public class AssetBundleKey {
    private String name;
    private String version;

    public AssetBundleKey(String name, String version) {
        this.name = ContentSystemUtil.trimSlashes(name);
        this.version = ContentSystemUtil.trimSlashes(version);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String url(String baseURL) {
        StringBuilder builder = new StringBuilder();
        builder.append(baseURL);
        if (!baseURL.endsWith("/")) {
            builder.append('/');
        }
        builder.append(this.name);
        builder.append('/');
        builder.append(this.version);
        builder.append('/');
        return builder.toString();
    }

    public String assetURL(String baseURL, AssetMetadata metadata) {
        StringBuilder builder = new StringBuilder();
        builder.append(baseURL);
        if (!baseURL.endsWith("/")) {
            builder.append('/');
        }
        String path = metadata.getPath();
        builder.append(this.name);
        builder.append('/');
        builder.append(this.version);
        if (!path.startsWith("/")) {
            builder.append('/');
        }
        builder.append(metadata.getPath());
        return builder.toString();
    }

    public String trimBundlePath(String path) {
        int bundleNameEnd = path.indexOf(47, 1);
        int versionEnd = path.indexOf(47, bundleNameEnd + 1);
        return path.substring(versionEnd + 1);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        builder.append(':');
        builder.append(this.version);
        return builder.toString();
    }
}

