/*
 * Decompiled with CFR 0.152.
 */
package io.konig.content;

import io.konig.content.AssetBundle;
import io.konig.content.AssetBundleKey;
import io.konig.content.AssetMetadata;
import io.konig.content.ContentAccessException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

public class AssetBundleReader {
    public AssetBundle readBundle(Reader reader) throws ContentAccessException, IOException {
        ArrayList<AssetMetadata> list = new ArrayList<AssetMetadata>();
        BufferedReader buffer = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        AssetBundleKey key = this.readKey(buffer);
        String line = null;
        while ((line = buffer.readLine()) != null) {
            int comma = line.indexOf(44);
            if (comma <= 0) continue;
            String path = line.substring(0, comma).trim();
            String etag = line.substring(comma + 1).trim();
            AssetMetadata asset = new AssetMetadata();
            asset.setBundleKey(key);
            asset.setEtag(etag);
            asset.setPath(path);
            list.add(asset);
        }
        AssetBundle bundle = new AssetBundle(key);
        bundle.setMetadataList(list);
        return bundle;
    }

    private AssetBundleKey readKey(BufferedReader reader) throws IOException, ContentAccessException {
        String name = null;
        String version = null;
        String line = reader.readLine();
        String[] parts = line.split(",");
        if (parts.length != 3) {
            throw new ContentAccessException("Invalid format");
        }
        block10: for (String data : parts) {
            NameValuePair pair = new NameValuePair(data);
            switch (pair.getName()) {
                case "format": {
                    if ("Bundle-1.0".equals(pair.getValue())) continue block10;
                    throw new ContentAccessException("Invalid format: " + pair.getValue());
                }
                case "name": {
                    name = pair.getValue();
                    continue block10;
                }
                case "version": {
                    version = pair.getValue();
                }
            }
        }
        if (name == null) {
            throw new ContentAccessException("Bundle name must be defined");
        }
        if (version == null) {
            throw new ContentAccessException("Bundle version must be defined");
        }
        return new AssetBundleKey(name, version);
    }

    static class NameValuePair {
        String name;
        String value;

        NameValuePair(String data) throws ContentAccessException {
            int equal = data.indexOf(61);
            if (equal <= 0) {
                throw new ContentAccessException("Invalid format");
            }
            this.name = data.substring(0, equal);
            this.value = data.substring(equal + 1);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

