/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.micronaut.logging.mdc;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.MDC;
import org.slf4j.Marker;

public class MDCTurboFilter
extends TurboFilter {
    private final Map<String, Boolean> cache = new HashMap<String, Boolean>();
    private final Set<String> loggers = new HashSet<String>();
    private final Set<String> values = new HashSet<String>();
    private String key;
    private Level level;

    public MDCTurboFilter setLoggers(Set<String> loggers) {
        this.cache.clear();
        this.loggers.clear();
        this.loggers.addAll(loggers);
        return this;
    }

    public MDCTurboFilter setValues(Set<String> values) {
        this.values.clear();
        this.values.addAll(values);
        return this;
    }

    public MDCTurboFilter setKey(String key) {
        this.key = key;
        return this;
    }

    public MDCTurboFilter setLevel(Level level) {
        this.level = level;
        return this;
    }

    public FilterReply decide(Marker marker, Logger logger, Level eventLevel, String format, Object[] params, Throwable t) {
        boolean isLoggerIncluded;
        if (logger == null || !this.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        String value = MDC.get((String)this.key);
        if (value == null || !this.values.isEmpty() && !this.values.contains(value)) {
            return FilterReply.NEUTRAL;
        }
        boolean bl = isLoggerIncluded = this.loggers.isEmpty() || this.cache.computeIfAbsent(logger.getName(), k -> this.loggers.stream().anyMatch(k::startsWith)) != false;
        if (!isLoggerIncluded) {
            return FilterReply.NEUTRAL;
        }
        return eventLevel.isGreaterOrEqual(this.level) ? FilterReply.ACCEPT : FilterReply.NEUTRAL;
    }
}

