/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.micronaut.logging.layout;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.contrib.json.classic.JsonLayout;
import io.micronaut.core.util.StringUtils;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class GcpJsonLayout
extends JsonLayout {
    private static final String UNDEFINED = "_IS_UNDEFINED";
    private static final String TIME_ATTR_NAME = "time";
    private static final String SEVERITY_ATTR_NAME = "severity";
    private Map<String, String> serviceContext;
    private String serviceName;
    private String serviceVersion;

    protected Map<String, Object> toJsonMap(ILoggingEvent event) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.add(TIME_ATTR_NAME, this.includeTimestamp, Instant.ofEpochMilli(event.getTimeStamp()).toString(), map);
        this.add(SEVERITY_ATTR_NAME, this.includeLevel, String.valueOf(event.getLevel()), map);
        this.add("thread", this.includeThreadName, event.getThreadName(), map);
        this.add("context", this.includeContextName, event.getLoggerContextVO().getName(), map);
        this.add("logger", this.includeLoggerName, event.getLoggerName(), map);
        this.addMap("mdc", this.includeMDC, event.getMDCPropertyMap(), map);
        this.add("message", this.includeFormattedMessage, event.getFormattedMessage(), map);
        this.add("raw-message", this.includeMessage, event.getMessage(), map);
        this.addThrowableInfo("exception", this.includeException, event, map);
        this.addServiceContext(map);
        return map;
    }

    private void addServiceContext(Map<String, Object> map) {
        if (this.serviceContext == null) {
            this.serviceContext = new HashMap<String, String>(2);
            if (StringUtils.isNotEmpty((CharSequence)this.serviceName) && !this.serviceName.endsWith(UNDEFINED)) {
                this.serviceContext.put("service", this.serviceName);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.serviceVersion) && !this.serviceVersion.endsWith(UNDEFINED)) {
                this.serviceContext.put("version", this.serviceVersion);
            }
        }
        if (!this.serviceContext.isEmpty()) {
            map.put("serviceContext", this.serviceContext);
        }
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }
}

