/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.micronaut.logging.http;

import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class AbstractMdcFilter
implements HttpServerFilter {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final int order;
    protected final String prefix;

    protected AbstractMdcFilter(Integer order, String prefix) {
        this.order = order;
        this.prefix = prefix;
    }

    public int getOrder() {
        return this.order;
    }

    protected Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain, Map<String, String> mdc) {
        if (mdc.isEmpty()) {
            return chain.proceed(request);
        }
        mdc.forEach((key, value) -> MDC.put((String)this.addPrefix((String)key), (String)value));
        return Publishers.map((Publisher)chain.proceed(request), response -> {
            mdc.keySet().forEach(key -> MDC.remove((String)this.addPrefix((String)key)));
            return response;
        });
    }

    private String addPrefix(String key) {
        return this.prefix == null ? key : this.prefix + key;
    }
}

