/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.micronaut.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.Context;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import jakarta.inject.Singleton;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.LoggerFactory;

@Requires(classes={LoggerContext.class})
@BootstrapContextCompatible
@Singleton
@Internal
public class LogbackUtil {
    private final LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();

    public <T extends TurboFilter> Optional<T> getTurboFilter(Class<T> type, String name) {
        return this.context.getTurboFilterList().stream().filter(filter -> Objects.equals(name, filter.getName())).filter(type::isInstance).map(type::cast).findAny();
    }

    public <T extends TurboFilter> T getTurboFilter(Class<T> type, String name, Supplier<T> defaultFilter) {
        return (T)this.getTurboFilter(type, name).orElseGet(() -> {
            TurboFilter filter = (TurboFilter)defaultFilter.get();
            filter.setName(name);
            filter.setContext((Context)this.context);
            this.context.addTurboFilter(filter);
            return filter;
        });
    }
}

