/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.micronaut.logging.request;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.filter.ServerFilterPhase;
import io.micronaut.runtime.server.EmbeddedServer;
import java.security.Principal;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.slf4j.MDC;

@Requirements(value={@Requires(beans={EmbeddedServer.class}), @Requires(property="logger.request.principal.enabled", notEquals="false")})
@Filter(value={"${logger.request.principal.path:/**}"})
public class PrincipalHttpFilter
implements HttpServerFilter {
    public static final String PREFIX = "logger.request.principal";
    public static final String DEFAULT_KEY = "principal";
    public static final int DEFAULT_ORDER = ServerFilterPhase.SECURITY.after();
    private final String key;
    private final int order;

    public PrincipalHttpFilter(@Value(value="${logger.request.principal.key:principal}") String key, @Value(value="${logger.request.principal.order}") Optional<Integer> order) {
        this.key = key;
        this.order = order.orElse(DEFAULT_ORDER);
    }

    public int getOrder() {
        return this.order;
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        Optional princial = request.getUserPrincipal();
        if (princial.isPresent()) {
            MDC.put((String)this.key, (String)((Principal)princial.get()).getName());
            return Publishers.map((Publisher)chain.proceed(request), response -> {
                MDC.remove((String)this.key);
                return response;
            });
        }
        return chain.proceed(request);
    }
}

