/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.micronaut.logging.request;

import ch.qos.logback.classic.turbo.TurboFilter;
import io.kokuwa.micronaut.logging.LogbackUtil;
import io.kokuwa.micronaut.logging.request.HeaderLoggingTurboFilter;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.filter.ServerFilterPhase;
import io.micronaut.runtime.server.EmbeddedServer;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.reactivestreams.Publisher;
import org.slf4j.MDC;

@Requirements(value={@Requires(beans={EmbeddedServer.class}), @Requires(property="logger.request.filter.enabled", notEquals="false")})
@Filter(value={"${logger.request.filter.path:/**}"})
public class HeaderLoggingServerHttpFilter
implements HttpServerFilter {
    public static final String PREFIX = "logger.request.filter";
    public static final String MDC_FILTER = "logger.request.filter";
    public static final String MDC_KEY = "level";
    public static final String DEFAULT_HEADER = "x-log-level";
    public static final int DEFAULT_ORDER = ServerFilterPhase.FIRST.before();
    private final LogbackUtil logback;
    private final String header;
    private final int order;

    public HeaderLoggingServerHttpFilter(LogbackUtil logback, @Value(value="${logger.request.filter.header}") Optional<String> header, @Value(value="${logger.request.filter.order}") Optional<Integer> order) {
        this.logback = logback;
        this.header = header.orElse(DEFAULT_HEADER);
        this.order = order.orElse(DEFAULT_ORDER);
    }

    @PostConstruct
    void startTurbofilter() {
        this.logback.getTurboFilter(HeaderLoggingTurboFilter.class, "logger.request.filter", HeaderLoggingTurboFilter::new).start();
    }

    @PreDestroy
    void stopTurbofilter() {
        this.logback.getTurboFilter(HeaderLoggingTurboFilter.class, "logger.request.filter").ifPresent(TurboFilter::stop);
    }

    public int getOrder() {
        return this.order;
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        Optional level = request.getHeaders().getFirst((CharSequence)this.header);
        if (level.isPresent()) {
            MDC.put((String)MDC_KEY, (String)((String)level.get()));
            return Publishers.map((Publisher)chain.proceed(request), response -> {
                MDC.remove((String)MDC_KEY);
                return response;
            });
        }
        return chain.proceed(request);
    }
}

