/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.micronaut.logging.request;

import io.kokuwa.micronaut.logging.request.HeaderLoggingServerHttpFilter;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Value;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.filter.ClientFilterChain;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.http.filter.ServerFilterPhase;
import java.util.Optional;
import org.reactivestreams.Publisher;

@Requirements(value={@Requires(beans={HeaderLoggingServerHttpFilter.class}), @Requires(property="logger.request.propagation.enabled", notEquals="false")})
@Filter(value={"${logger.request.propagation.path:/**}"})
public class HeaderLoggingClientHttpFilter
implements HttpClientFilter {
    public static final String PREFIX = "logger.request.propagation";
    public static final int DEFAULT_ORDER = ServerFilterPhase.TRACING.order();
    private final String serverHeader;
    private final String propagationHeader;
    private final int order;

    public HeaderLoggingClientHttpFilter(@Value(value="${logger.request.filter.header}") Optional<String> serverHeader, @Value(value="${logger.request.propagation.header}") Optional<String> propagationHeader, @Value(value="${logger.request.propagation.order}") Optional<Integer> order) {
        this.serverHeader = serverHeader.orElse("x-log-level");
        this.propagationHeader = propagationHeader.orElse(this.serverHeader);
        this.order = order.orElse(DEFAULT_ORDER);
    }

    public int getOrder() {
        return this.order;
    }

    public Publisher<? extends HttpResponse<?>> doFilter(MutableHttpRequest<?> targetRequest, ClientFilterChain chain) {
        ServerRequestContext.currentRequest().flatMap(currentRequest -> currentRequest.getHeaders().getFirst((CharSequence)this.serverHeader)).ifPresent(level -> targetRequest.getHeaders().add((CharSequence)this.propagationHeader, (CharSequence)level));
        return chain.proceed(targetRequest);
    }
}

