/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.micronaut.logging.configurator;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import io.micronaut.core.util.StringUtils;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.Attributes;

public class RootAutoSelectAppenderAction
extends Action {
    private static final boolean IS_KUBERNETES = StringUtils.isNotEmpty((CharSequence)System.getenv("KUBERNETES_SERVICE_HOST"));
    private static final boolean IS_GCP = StringUtils.isNotEmpty((CharSequence)System.getenv("GOOGLE_CLOUD_PROJECT"));
    private static final String APPENDER_CONSOLE = "CONSOLE";
    private static final String APPENDER_JSON = "JSON";
    private static final String APPENDER_GCP = "GCP";
    private static final String LOGBACK_APPENDER = "LOGBACK_APPENDER";

    public void begin(InterpretationContext ic, String name, Attributes attributes) {
        Logger rootLogger = ((LoggerContext)LoggerContext.class.cast(this.context)).getLogger("ROOT");
        Iterator rootLoggerAppenders = rootLogger.iteratorForAppenders();
        if (rootLoggerAppenders.hasNext()) {
            this.addWarn("Skip because appender already found: " + ((Appender)rootLoggerAppenders.next()).getName());
            return;
        }
        String envAppender = System.getenv(LOGBACK_APPENDER);
        if (envAppender != null && this.setAppender(ic, rootLogger, envAppender)) {
            return;
        }
        if (IS_KUBERNETES && this.setAppender(ic, rootLogger, APPENDER_JSON)) {
            return;
        }
        if (IS_GCP && this.setAppender(ic, rootLogger, APPENDER_GCP)) {
            return;
        }
        this.setAppender(ic, rootLogger, APPENDER_CONSOLE);
    }

    public void end(InterpretationContext ic, String name) {
    }

    private boolean setAppender(InterpretationContext ic, Logger rootLogger, String appenderName) {
        Map appenderBag = (Map)ic.getObjectMap().get("APPENDER_BAG");
        Appender appender = (Appender)appenderBag.get(appenderName);
        if (appender == null) {
            this.addError("Could not find an appender named [" + appenderName + "]. Did you define it below instead of above in the configuration file?");
            return false;
        }
        this.addInfo("Use appender: " + appenderName);
        rootLogger.addAppender(appender);
        return true;
    }
}

