/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.micronaut.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.contrib.jackson.JacksonJsonFormatter;
import ch.qos.logback.contrib.json.JsonFormatter;
import ch.qos.logback.contrib.json.classic.JsonLayout;
import io.micronaut.core.util.StringUtils;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class StackdriverJsonLayout
extends JsonLayout {
    private static final String TIMESTAMP_ATTR_NAME = "time";
    private static final String SEVERITY_ATTR_NAME = "severity";
    private Map<String, String> serviceContext;
    private String serviceName;
    private String serviceVersion;
    private boolean includeExceptionInMessage;

    public StackdriverJsonLayout() {
        this.appendLineSeparator = true;
        this.includeContextName = false;
        this.includeMessage = true;
        this.includeExceptionInMessage = true;
        this.setJsonFormatter((JsonFormatter)new JacksonJsonFormatter());
    }

    protected Map<String, Object> toJsonMap(ILoggingEvent event) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.add(TIMESTAMP_ATTR_NAME, this.includeTimestamp, Instant.ofEpochMilli(event.getTimeStamp()).toString(), map);
        this.add(SEVERITY_ATTR_NAME, this.includeLevel, String.valueOf(event.getLevel()), map);
        this.add("thread", this.includeThreadName, event.getThreadName(), map);
        this.add("context", this.includeContextName, event.getLoggerContextVO().getName(), map);
        this.add("logger", this.includeLoggerName, event.getLoggerName(), map);
        this.addMap("mdc", this.includeMDC, event.getMDCPropertyMap(), map);
        this.add("message", this.includeFormattedMessage, event.getFormattedMessage(), map);
        this.add("raw-message", this.includeMessage, event.getMessage(), map);
        this.addThrowableInfo("exception", this.includeException, event, map);
        this.addServiceContext(map);
        return map;
    }

    private void addServiceContext(Map<String, Object> map) {
        if (this.serviceContext == null) {
            this.serviceContext = new HashMap<String, String>(2);
            if (StringUtils.isNotEmpty((CharSequence)this.serviceName)) {
                this.serviceContext.put("service", this.serviceName);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.serviceVersion)) {
                this.serviceContext.put("version", this.serviceVersion);
            }
        }
        if (!this.serviceContext.isEmpty()) {
            map.put("serviceContext", this.serviceContext);
        }
    }

    public Map<String, String> getServiceContext() {
        return this.serviceContext;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceVersion() {
        return this.serviceVersion;
    }

    public boolean isIncludeExceptionInMessage() {
        return this.includeExceptionInMessage;
    }

    public void setServiceContext(Map<String, String> serviceContext) {
        this.serviceContext = serviceContext;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public void setIncludeExceptionInMessage(boolean includeExceptionInMessage) {
        this.includeExceptionInMessage = includeExceptionInMessage;
    }
}

