/*
 * Decompiled with CFR 0.152.
 */
package io.kojan.javadeptools.rpm;

import io.kojan.javadeptools.rpm.Rpm;
import io.kojan.javadeptools.rpm.RpmInfo;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RpmQuery {
    private RpmQuery() {
    }

    public static List<RpmInfo> byFile(Path path) {
        return RpmQuery.byFile(path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RpmInfo> byFile(Path path, Path root) {
        Rpm.RpmTS ts = Rpm.rpmtsCreate();
        try {
            List<RpmInfo> list;
            if (root != null && Rpm.rpmtsSetRootDir(ts, root.toString()) != 0) {
                List<RpmInfo> list2 = Collections.emptyList();
                return list2;
            }
            Rpm.RpmMI mi = Rpm.rpmtsInitIterator(ts, 5040, path.toAbsolutePath().toString(), 0L);
            try {
                Rpm.RpmHeader h;
                ArrayList<RpmInfo> providers = new ArrayList<RpmInfo>();
                while ((h = Rpm.rpmdbNextIterator(mi)) != null) {
                    providers.add(new RpmInfo(h));
                }
                list = Collections.unmodifiableList(providers);
            }
            catch (Throwable throwable) {
                Rpm.rpmdbFreeIterator(mi);
                throw throwable;
            }
            Rpm.rpmdbFreeIterator(mi);
            return list;
        }
        finally {
            Rpm.rpmtsFree(ts);
        }
    }

    static {
        Rpm.rpmReadConfigFiles(null, null);
    }
}

