/*
 * Decompiled with CFR 0.152.
 */
package io.kojan.javadeptools.rpm;

import io.kojan.javadeptools.nativ.Native;
import io.kojan.javadeptools.nativ.NativePointer;
import io.kojan.javadeptools.rpm.Rpm;
import io.kojan.javadeptools.rpm.RpmInfo;
import java.io.IOException;
import java.nio.file.Path;

public class RpmPackage {
    private final Path path;
    private final RpmInfo info;
    private final long headerSize;

    private static IOException error(Path path, String message) throws IOException {
        throw new IOException("Unable to open RPM file " + String.valueOf(path) + ": " + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RpmPackage(Path path) throws IOException {
        this.path = path;
        Rpm.RpmTS ts = Rpm.rpmtsCreate();
        Rpm.RpmFD fd = Rpm.Fopen(path.toString(), "r");
        try {
            if (Rpm.Ferror(fd) != 0) {
                throw RpmPackage.error(path, Rpm.Fstrerror(fd));
            }
            Rpm.rpmtsSetVSFlags(ts, 920833);
            NativePointer<Rpm.RpmHeader> ph = Native.newPointer(Rpm.RpmHeader.class);
            int rc = Rpm.rpmReadPackageFile(ts, fd, null, ph);
            if (rc == 1) {
                throw RpmPackage.error(path, "Not a RPM file");
            }
            if (rc != 0 && rc != 3 && rc != 4) {
                throw RpmPackage.error(path, "Failed to parse RPM header");
            }
            Rpm.RpmHeader h = ph.dereference();
            try {
                this.info = new RpmInfo(h);
            }
            finally {
                Rpm.headerFree(h);
            }
            this.headerSize = Rpm.Ftell(fd);
        }
        finally {
            Rpm.Fclose(fd);
            Rpm.rpmtsFree(ts);
        }
    }

    public Path getPath() {
        return this.path;
    }

    public RpmInfo getInfo() {
        return this.info;
    }

    long getHeaderSize() {
        return this.headerSize;
    }

    public String toString() {
        return this.info.toString();
    }

    public int hashCode() {
        return this.info.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof RpmPackage && ((RpmPackage)obj).info.equals(this.info);
    }
}

