/*
 * Decompiled with CFR 0.152.
 */
package io.kojan.javadeptools.rpm;

import io.kojan.javadeptools.rpm.Rpm;
import io.kojan.javadeptools.rpm.RpmVersion;

public class RpmDependency {
    private static final String[] SENSES = new String[]{"", "<", ">", "<>", "=", "<=", ">=", "<>="};
    private final String dnevr;
    private final String name;
    private final int flags;
    private final RpmVersion version;
    private final boolean isRich;

    RpmDependency(Rpm.RpmDS ds) {
        this.dnevr = Rpm.rpmdsDNEVR(ds);
        this.name = Rpm.rpmdsN(ds);
        this.flags = Rpm.rpmdsFlags(ds);
        this.version = new RpmVersion(Rpm.rpmdsEVR(ds));
        this.isRich = Rpm.rpmdsIsRich(ds) != 0;
    }

    public String getName() {
        return this.name;
    }

    public String getSense() {
        return SENSES[(this.flags & 0xF) >> 1];
    }

    public RpmVersion getVersion() {
        return this.version;
    }

    public boolean isRich() {
        return this.isRich;
    }

    public String toString() {
        return this.dnevr.substring(2);
    }

    public int hashCode() {
        return this.dnevr.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof RpmDependency && ((RpmDependency)obj).dnevr.equals(this.dnevr);
    }
}

