/*
 * Decompiled with CFR 0.152.
 */
package io.kojan.javadeptools.rpm;

import io.kojan.javadeptools.rpm.RpmInfo;
import io.kojan.javadeptools.rpm.RpmPackage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.lzma.LZMACompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;

public class RpmArchiveInputStream
extends ArchiveInputStream<CpioArchiveEntry> {
    private final CpioArchiveInputStream delegate;

    public RpmArchiveInputStream(Path path) throws IOException {
        this(new RpmPackage(path));
    }

    public RpmArchiveInputStream(RpmPackage rpm) throws IOException {
        this.delegate = RpmArchiveInputStream.wrapFile(rpm);
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public CpioArchiveEntry getNextEntry() throws IOException {
        return this.delegate.getNextEntry();
    }

    public int read() throws IOException {
        return this.delegate.read();
    }

    public int read(byte[] buf) throws IOException {
        return this.delegate.read(buf);
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        return this.delegate.read(buf, off, len);
    }

    private static IOException error(Path path, String message) throws IOException {
        throw new IOException("Unable to open RPM file " + String.valueOf(path) + ": " + message);
    }

    private static boolean hasGzipMagic(InputStream fis) throws IOException {
        try {
            fis.mark(2);
            boolean bl = fis.read() == 31 && fis.read() == 139;
            return bl;
        }
        finally {
            fis.reset();
        }
    }

    private static CpioArchiveInputStream wrapFile(RpmPackage rpm) throws IOException {
        Object cis;
        RpmInfo info = rpm.getInfo();
        BufferedInputStream fis = new BufferedInputStream(Files.newInputStream(rpm.getPath(), new OpenOption[0]));
        ((InputStream)fis).skip(rpm.getHeaderSize());
        cis = switch (info.getCompressionMethod()) {
            case "gzip" -> {
                if (RpmArchiveInputStream.hasGzipMagic(fis)) {
                    yield new GzipCompressorInputStream((InputStream)fis, true);
                }
                yield fis;
            }
            case "bzip2" -> new BZip2CompressorInputStream((InputStream)fis);
            case "xz" -> cis = new XZCompressorInputStream((InputStream)fis);
            case "lzma" -> cis = new LZMACompressorInputStream((InputStream)fis);
            case "zstd" -> cis = new ZstdCompressorInputStream((InputStream)fis);
            default -> {
                ((InputStream)fis).close();
                throw RpmArchiveInputStream.error(rpm.getPath(), "Unsupported compression method: " + info.getCompressionMethod());
            }
        };
        if (!info.getArchiveFormat().equals("cpio")) {
            ((InputStream)cis).close();
            throw RpmArchiveInputStream.error(rpm.getPath(), "Unsupported archive format: " + info.getArchiveFormat());
        }
        return new CpioArchiveInputStream((InputStream)cis);
    }
}

