/*
 * Decompiled with CFR 0.152.
 */
package io.kojan.javadeptools.rpm;

import io.kojan.javadeptools.nativ.Native;
import io.kojan.javadeptools.nativ.NativeDataStructure;
import io.kojan.javadeptools.nativ.NativePointer;

final class Rpm {
    static final int RPMRC_OK = 0;
    static final int RPMRC_NOTFOUND = 1;
    static final int RPMRC_FAIL = 2;
    static final int RPMRC_NOTTRUSTED = 3;
    static final int RPMRC_NOKEY = 4;
    static final int RPMVSF_NOHDRCHK = 1;
    static final int RPMVSF_NOSHA1HEADER = 256;
    static final int RPMVSF_NODSAHEADER = 1024;
    static final int RPMVSF_NORSAHEADER = 2048;
    static final int RPMVSF_NOMD5 = 131072;
    static final int RPMVSF_NODSA = 262144;
    static final int RPMVSF_NORSA = 524288;
    static final int RPMTAG_NAME = 1000;
    static final int RPMTAG_VERSION = 1001;
    static final int RPMTAG_RELEASE = 1002;
    static final int RPMTAG_EPOCH = 1003;
    static final int RPMTAG_LICENSE = 1014;
    static final int RPMTAG_ARCH = 1022;
    static final int RPMTAG_SOURCERPM = 1044;
    static final int RPMTAG_PROVIDENAME = 1047;
    static final int RPMTAG_REQUIRENAME = 1049;
    static final int RPMTAG_CONFLICTNAME = 1054;
    static final int RPMTAG_EXCLUSIVEARCH = 1061;
    static final int RPMTAG_BUILDARCHS = 1089;
    static final int RPMTAG_OBSOLETENAME = 1090;
    static final int RPMTAG_SOURCEPACKAGE = 1106;
    static final int RPMTAG_PAYLOADCOMPRESSOR = 1125;
    static final int RPMTAG_PAYLOADFORMAT = 1124;
    static final int RPMTAG_ORDERNAME = 5035;
    static final int RPMTAG_RECOMMENDNAME = 5046;
    static final int RPMTAG_SUGGESTNAME = 5049;
    static final int RPMTAG_SUPPLEMENTNAME = 5052;
    static final int RPMTAG_ENHANCENAME = 5055;
    static final int HEADERGET_MINMEM = 1;
    static final int RPMDBI_INSTFILENAMES = 5040;

    Rpm() {
    }

    static final RpmFD Fopen(String path, String mode) {
        return LazyIO.RPMIO.Fopen(path, mode);
    }

    static final void Fclose(RpmFD fd) {
        LazyIO.RPMIO.Fclose(fd);
    }

    static final long Ftell(RpmFD fd) {
        return LazyIO.RPMIO.Ftell(fd);
    }

    static final int Ferror(RpmFD fd) {
        return LazyIO.RPMIO.Ferror(fd);
    }

    static final String Fstrerror(RpmFD fd) {
        return LazyIO.RPMIO.Fstrerror(fd);
    }

    static final int rpmReadConfigFiles(String file, String target) {
        return Lazy.RPM.rpmReadConfigFiles(file, target);
    }

    static final RpmTS rpmtsCreate() {
        return Lazy.RPM.rpmtsCreate();
    }

    static final void rpmtsFree(RpmTS ts) {
        Lazy.RPM.rpmtsFree(ts);
    }

    static final int rpmtsSetRootDir(RpmTS ts, String rootDir) {
        return Lazy.RPM.rpmtsSetRootDir(ts, rootDir);
    }

    static final RpmMI rpmtsInitIterator(RpmTS ts, int rpmtag, String keyp, long keylen) {
        return Lazy.RPM.rpmtsInitIterator(ts, rpmtag, keyp, keylen);
    }

    static final void rpmtsSetVSFlags(RpmTS ts, int vsflags) {
        Lazy.RPM.rpmtsSetVSFlags(ts, vsflags);
    }

    static final RpmHeader rpmdbNextIterator(RpmMI mi) {
        return Lazy.RPM.rpmdbNextIterator(mi);
    }

    static final void rpmdbFreeIterator(RpmMI mi) {
        Lazy.RPM.rpmdbFreeIterator(mi);
    }

    static final int rpmReadPackageFile(RpmTS ts, RpmFD fd, String fn, NativePointer<RpmHeader> hdrp) {
        return Lazy.RPM.rpmReadPackageFile(ts, fd, fn, hdrp);
    }

    static final void headerFree(RpmHeader h) {
        Lazy.RPM.headerFree(h);
    }

    static final int headerGet(RpmHeader h, int tag, RpmTD td, int flags) {
        return Lazy.RPM.headerGet(h, tag, td, flags);
    }

    static final String headerGetString(RpmHeader h, int tag) {
        return Lazy.RPM.headerGetString(h, tag);
    }

    static final long headerGetNumber(RpmHeader h, int tag) {
        return Lazy.RPM.headerGetNumber(h, tag);
    }

    static final RpmTD rpmtdNew() {
        return Lazy.RPM.rpmtdNew();
    }

    static final int rpmtdCount(RpmTD td) {
        return Lazy.RPM.rpmtdCount(td);
    }

    static final int rpmtdNext(RpmTD td) {
        return Lazy.RPM.rpmtdNext(td);
    }

    static final String rpmtdGetString(RpmTD td) {
        return Lazy.RPM.rpmtdGetString(td);
    }

    static final long rpmtdGetNumber(RpmTD td) {
        return Lazy.RPM.rpmtdGetNumber(td);
    }

    static final void rpmtdFree(RpmTD td) {
        Lazy.RPM.rpmtdFree(td);
    }

    static final RpmDS rpmdsNew(RpmHeader h, int tagN, int flags) {
        return Lazy.RPM.rpmdsNew(h, tagN, flags);
    }

    static final void rpmdsFree(RpmDS ds) {
        Lazy.RPM.rpmdsFree(ds);
    }

    static final int rpmdsNext(RpmDS ds) {
        return Lazy.RPM.rpmdsNext(ds);
    }

    static final String rpmdsDNEVR(RpmDS ds) {
        return Lazy.RPM.rpmdsDNEVR(ds);
    }

    static final String rpmdsN(RpmDS ds) {
        return Lazy.RPM.rpmdsN(ds);
    }

    static final String rpmdsEVR(RpmDS ds) {
        return Lazy.RPM.rpmdsEVR(ds);
    }

    static final int rpmdsFlags(RpmDS ds) {
        return Lazy.RPM.rpmdsFlags(ds);
    }

    static final int rpmdsIsRich(RpmDS ds) {
        return Lazy.RPM.rpmdsIsRich(ds);
    }

    static final RpmEVR rpmverParse(String evr) {
        return LazyIO.RPMIO.rpmverParse(evr);
    }

    static final void rpmverFree(RpmEVR rv) {
        LazyIO.RPMIO.rpmverFree(rv);
    }

    static final long rpmverEVal(RpmEVR rv) {
        return LazyIO.RPMIO.rpmverEVal(rv);
    }

    static final String rpmverE(RpmEVR rv) {
        return LazyIO.RPMIO.rpmverE(rv);
    }

    static final String rpmverV(RpmEVR rv) {
        return LazyIO.RPMIO.rpmverV(rv);
    }

    static final String rpmverR(RpmEVR rv) {
        return LazyIO.RPMIO.rpmverR(rv);
    }

    private static class LazyIO {
        static final RpmIO RPMIO = Native.load(RpmIO.class, "librpmio.so.9");

        private LazyIO() {
        }
    }

    private static interface RpmIO {
        public RpmFD Fopen(String var1, String var2);

        public void Fclose(RpmFD var1);

        public long Ftell(RpmFD var1);

        public int Ferror(RpmFD var1);

        public String Fstrerror(RpmFD var1);

        public RpmEVR rpmverParse(String var1);

        public void rpmverFree(RpmEVR var1);

        public long rpmverEVal(RpmEVR var1);

        public String rpmverE(RpmEVR var1);

        public String rpmverV(RpmEVR var1);

        public String rpmverR(RpmEVR var1);
    }

    static class RpmFD
    extends NativeDataStructure {
        RpmFD() {
        }
    }

    private static class Lazy {
        static final RpmLib RPM = Native.load(RpmLib.class, "librpm.so.9");

        private Lazy() {
        }
    }

    private static interface RpmLib {
        public int rpmReadConfigFiles(String var1, String var2);

        public RpmTS rpmtsCreate();

        public void rpmtsFree(RpmTS var1);

        public int rpmtsSetRootDir(RpmTS var1, String var2);

        public RpmMI rpmtsInitIterator(RpmTS var1, int var2, String var3, long var4);

        public void rpmtsSetVSFlags(RpmTS var1, int var2);

        public RpmHeader rpmdbNextIterator(RpmMI var1);

        public void rpmdbFreeIterator(RpmMI var1);

        public int rpmReadPackageFile(RpmTS var1, RpmFD var2, String var3, NativePointer<RpmHeader> var4);

        public void headerFree(RpmHeader var1);

        public int headerGet(RpmHeader var1, int var2, RpmTD var3, int var4);

        public String headerGetString(RpmHeader var1, int var2);

        public long headerGetNumber(RpmHeader var1, int var2);

        public RpmTD rpmtdNew();

        public int rpmtdCount(RpmTD var1);

        public int rpmtdNext(RpmTD var1);

        public String rpmtdGetString(RpmTD var1);

        public long rpmtdGetNumber(RpmTD var1);

        public void rpmtdFree(RpmTD var1);

        public RpmDS rpmdsNew(RpmHeader var1, int var2, int var3);

        public void rpmdsFree(RpmDS var1);

        public int rpmdsNext(RpmDS var1);

        public String rpmdsDNEVR(RpmDS var1);

        public String rpmdsN(RpmDS var1);

        public String rpmdsEVR(RpmDS var1);

        public int rpmdsFlags(RpmDS var1);

        public int rpmdsIsRich(RpmDS var1);
    }

    static class RpmTS
    extends NativeDataStructure {
        RpmTS() {
        }
    }

    static class RpmMI
    extends NativeDataStructure {
        RpmMI() {
        }
    }

    static class RpmHeader
    extends NativeDataStructure {
        RpmHeader() {
        }
    }

    static class RpmTD
    extends NativeDataStructure {
        RpmTD() {
        }
    }

    static class RpmDS
    extends NativeDataStructure {
        RpmDS() {
        }
    }

    static class RpmEVR
    extends NativeDataStructure {
        RpmEVR() {
        }
    }
}

