/*
 * Decompiled with CFR 0.152.
 */
package io.kojan.javadeptools.nativ;

import io.kojan.javadeptools.nativ.NativeDataStructure;
import io.kojan.javadeptools.nativ.NativePointer;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.reflect.Constructor;

class NativePointerImpl<T extends NativeDataStructure>
extends NativePointer<T> {
    private final Constructor<T> ctr;

    public NativePointerImpl(Class<T> type) {
        try {
            this.ctr = type.getDeclaredConstructor(new Class[0]);
            this.ctr.setAccessible(true);
            this.ms = Arena.ofAuto().allocate(ValueLayout.ADDRESS);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T dereference() {
        MemorySegment address = ((MemorySegment)this.ms).get(ValueLayout.ADDRESS, 0L);
        if (address.equals(MemorySegment.NULL)) {
            return null;
        }
        try {
            NativeDataStructure obj = (NativeDataStructure)this.ctr.newInstance(new Object[0]);
            obj.ms = address;
            return (T)obj;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

