/*
 * Decompiled with CFR 0.152.
 */
package io.kojan.javadeptools.rpm;

import io.kojan.javadeptools.rpm.Rpm;

public class RpmVersion {
    private final String evr;
    private final Long epoch;
    private final String version;
    private final String release;

    public RpmVersion(String evr) {
        this.evr = evr;
        Rpm.RpmEVR v = Rpm.rpmverParse(evr);
        this.epoch = Rpm.rpmverE(v) != null ? Long.valueOf(Rpm.rpmverEVal(v)) : null;
        this.version = Rpm.rpmverV(v);
        this.release = Rpm.rpmverR(v);
        Rpm.rpmverFree(v);
    }

    public Long getEpoch() {
        return this.epoch;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRelease() {
        return this.release;
    }

    public String toString() {
        return this.evr;
    }

    public int hashCode() {
        return this.evr.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof RpmVersion && ((RpmVersion)obj).evr.equals(this.evr);
    }
}

