/*
 * Decompiled with CFR 0.152.
 */
package io.kojan.javadeptools.rpm;

import io.kojan.javadeptools.rpm.Rpm;
import io.kojan.javadeptools.rpm.RpmDependency;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class RpmInfo {
    private final String name;
    private final Optional<Long> epoch;
    private final String version;
    private final String release;
    private final String arch;
    private final String nevra;
    private final boolean sourcePackage;
    private final String license;
    private final String sourceRPM;
    private final List<String> exclusiveArch;
    private final List<String> buildArchs;
    private final List<RpmDependency> provides;
    private final List<RpmDependency> requires;
    private final List<RpmDependency> conflicts;
    private final List<RpmDependency> obsoletes;
    private final List<RpmDependency> recommends;
    private final List<RpmDependency> suggests;
    private final List<RpmDependency> supplements;
    private final List<RpmDependency> enhances;
    private final List<RpmDependency> orderWithRequires;
    private final String archiveFormat;
    private final String compressionMethod;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> headerGetList(Rpm.RpmHeader h, int tag) {
        Rpm.RpmTD td = Rpm.rpmtdNew();
        Rpm.headerGet(h, tag, td, 1);
        try {
            int size = Rpm.rpmtdCount(td);
            String[] list = new String[size];
            for (int i = 0; i < size; ++i) {
                Rpm.rpmtdNext(td);
                list[i] = Rpm.rpmtdGetString(td);
            }
            List<String> list2 = Collections.unmodifiableList(Arrays.asList(list));
            return list2;
        }
        finally {
            Rpm.rpmtdFree(td);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Optional<Long> headerGetOptionalNumber(Rpm.RpmHeader h, int tag) {
        Rpm.RpmTD td = Rpm.rpmtdNew();
        Rpm.headerGet(h, tag, td, 1);
        try {
            if (Rpm.rpmtdNext(td) == 0) {
                Optional<Long> optional = Optional.of(Rpm.rpmtdGetNumber(td));
                return optional;
            }
            Optional<Long> optional = Optional.empty();
            return optional;
        }
        finally {
            Rpm.rpmtdFree(td);
        }
    }

    private static List<RpmDependency> dependencyList(Rpm.RpmHeader h, int tag) {
        ArrayList<RpmDependency> list = new ArrayList<RpmDependency>();
        Rpm.RpmDS ds = Rpm.rpmdsNew(h, tag, 0);
        while (Rpm.rpmdsNext(ds) >= 0) {
            list.add(new RpmDependency(ds));
        }
        Rpm.rpmdsFree(ds);
        return list;
    }

    RpmInfo(Rpm.RpmHeader h) {
        this.name = Rpm.headerGetString(h, 1000);
        this.epoch = RpmInfo.headerGetOptionalNumber(h, 1003);
        this.version = Rpm.headerGetString(h, 1001);
        this.release = Rpm.headerGetString(h, 1002);
        this.arch = Rpm.headerGetString(h, 1022);
        this.license = Rpm.headerGetString(h, 1014);
        this.sourceRPM = Rpm.headerGetString(h, 1044);
        this.exclusiveArch = RpmInfo.headerGetList(h, 1061);
        this.buildArchs = RpmInfo.headerGetList(h, 1089);
        this.provides = RpmInfo.dependencyList(h, 1047);
        this.requires = RpmInfo.dependencyList(h, 1049);
        this.conflicts = RpmInfo.dependencyList(h, 1054);
        this.obsoletes = RpmInfo.dependencyList(h, 1090);
        this.recommends = RpmInfo.dependencyList(h, 5046);
        this.suggests = RpmInfo.dependencyList(h, 5049);
        this.supplements = RpmInfo.dependencyList(h, 5052);
        this.enhances = RpmInfo.dependencyList(h, 5055);
        this.orderWithRequires = RpmInfo.dependencyList(h, 5035);
        this.archiveFormat = Rpm.headerGetString(h, 1124);
        this.compressionMethod = Rpm.headerGetString(h, 1125);
        this.sourcePackage = Rpm.headerGetNumber(h, 1106) != 0L;
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append('-');
        if (this.epoch.isPresent()) {
            sb.append(String.valueOf(this.epoch.get()) + ":");
        }
        sb.append(this.version).append('-').append(this.release);
        sb.append('.').append(this.arch);
        this.nevra = sb.toString();
    }

    public String getLicense() {
        return this.license;
    }

    public String getSourceRPM() {
        return this.sourceRPM;
    }

    public List<String> getExclusiveArch() {
        return this.exclusiveArch;
    }

    public List<String> getBuildArchs() {
        return this.buildArchs;
    }

    public String getName() {
        return this.name;
    }

    public Optional<Long> getEpoch() {
        return this.epoch;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRelease() {
        return this.release;
    }

    public String getArch() {
        return this.arch;
    }

    public boolean isSourcePackage() {
        return this.sourcePackage;
    }

    public List<RpmDependency> getProvides() {
        return this.provides;
    }

    public List<RpmDependency> getRequires() {
        return this.requires;
    }

    public List<RpmDependency> getConflicts() {
        return this.conflicts;
    }

    public List<RpmDependency> getObsoletes() {
        return this.obsoletes;
    }

    public List<RpmDependency> getRecommends() {
        return this.recommends;
    }

    public List<RpmDependency> getSuggests() {
        return this.suggests;
    }

    public List<RpmDependency> getSupplements() {
        return this.supplements;
    }

    public List<RpmDependency> getEnhances() {
        return this.enhances;
    }

    public List<RpmDependency> getOrderWithRequires() {
        return this.orderWithRequires;
    }

    String getArchiveFormat() {
        return this.archiveFormat != null ? this.archiveFormat : "cpio";
    }

    String getCompressionMethod() {
        return this.compressionMethod != null ? this.compressionMethod : "gzip";
    }

    public String toString() {
        return this.nevra.toString();
    }

    public int hashCode() {
        return this.nevra.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof RpmInfo && ((RpmInfo)obj).nevra.equals(this.nevra);
    }
}

