/*
 * Decompiled with CFR 0.152.
 */
package io.kojan.javadeptools.nativ;

import io.kojan.javadeptools.nativ.DynamicLinker;
import io.kojan.javadeptools.nativ.NativeDataStructure;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

class NativeInvocationHandler
implements InvocationHandler {
    private Map<Method, Stub> stubs = new LinkedHashMap<Method, Stub>();

    private static MemoryLayout selectLayout(Class<?> type) {
        ValueLayout valueLayout;
        Class<?> clazz = type;
        Objects.requireNonNull(clazz);
        Class<?> clazz2 = clazz;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, Class.class, Class.class, Class.class}, clazz2, n)) {
                case 0: {
                    Class<?> cls = clazz2;
                    if (!String.class.isAssignableFrom(cls)) {
                        n = 1;
                        continue block6;
                    }
                    valueLayout = ValueLayout.ADDRESS.withTargetLayout(MemoryLayout.sequenceLayout(ValueLayout.JAVA_BYTE));
                    break block6;
                }
                case 1: {
                    Class<?> cls = clazz2;
                    if (!NativeDataStructure.class.isAssignableFrom(cls)) {
                        n = 2;
                        continue block6;
                    }
                    valueLayout = ValueLayout.ADDRESS;
                    break block6;
                }
                case 2: {
                    Class<?> cls = clazz2;
                    if (!Long.TYPE.isAssignableFrom(cls)) {
                        n = 3;
                        continue block6;
                    }
                    valueLayout = ValueLayout.JAVA_LONG;
                    break block6;
                }
                case 3: {
                    Class<?> cls = clazz2;
                    if (!Integer.TYPE.isAssignableFrom(cls)) {
                        n = 4;
                        continue block6;
                    }
                    valueLayout = ValueLayout.JAVA_INT;
                    break block6;
                }
                default: {
                    throw new IllegalStateException("data type is not supported: " + String.valueOf(type));
                }
            }
            break;
        }
        return valueLayout;
    }

    public NativeInvocationHandler(Class<?> iface, String lib) throws ReflectiveOperationException {
        Linker linker = Linker.nativeLinker();
        SymbolLookup lookup = lib != null ? new DynamicLinker(lib) : linker.defaultLookup();
        for (Method method : iface.getDeclaredMethods()) {
            MemoryLayout[] argLayouts = new MemoryLayout[method.getParameterCount()];
            DownConverter[] argConvs = new DownConverter[method.getParameterCount()];
            int i = 0;
            for (Class<?> type : method.getParameterTypes()) {
                argLayouts[i] = NativeInvocationHandler.selectLayout(type);
                argConvs[i] = DownConverter.forType(type);
                ++i;
            }
            Optional<MemorySegment> methodAddress = lookup.find(method.getName());
            if (methodAddress.isEmpty()) {
                throw new RuntimeException("Native method was not bound: " + method.getName());
            }
            MethodHandle mh = method.getReturnType().equals(Void.TYPE) ? linker.downcallHandle(methodAddress.get(), FunctionDescriptor.ofVoid(argLayouts), new Linker.Option[0]) : linker.downcallHandle(methodAddress.get(), FunctionDescriptor.of(NativeInvocationHandler.selectLayout(method.getReturnType()), argLayouts), new Linker.Option[0]);
            UpConverter retConv = UpConverter.forType(method.getReturnType());
            Stub stub = new Stub(mh, argConvs, retConv);
            this.stubs.put(method, stub);
        }
    }

    @Override
    public Object invoke(Object object, Method method, Object[] args) throws Throwable {
        try (Arena arena = Arena.ofConfined();){
            Stub stub;
            if (args == null) {
                args = new Object[]{};
            }
            if ((stub = this.stubs.get(method)) == null) {
                throw new IllegalStateException("No stub was bound for method " + String.valueOf(method));
            }
            Object object2 = stub.invoke(args, arena);
            return object2;
        }
    }

    private static interface DownConverter {
        public Object convert(Object var1, Arena var2) throws Throwable;

        public static DownConverter forType(Class<?> type) {
            DownConverter downConverter;
            Class<?> clazz = type;
            Objects.requireNonNull(clazz);
            Class<?> clazz2 = clazz;
            int n = 0;
            block4: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, Class.class}, clazz2, n)) {
                    case 0: {
                        Class<?> cls = clazz2;
                        if (!String.class.isAssignableFrom(cls)) {
                            n = 1;
                            continue block4;
                        }
                        downConverter = (obj, arena) -> arena.allocateUtf8String((String)obj);
                        break block4;
                    }
                    case 1: {
                        Class<?> cls = clazz2;
                        if (!NativeDataStructure.class.isAssignableFrom(cls)) {
                            n = 2;
                            continue block4;
                        }
                        downConverter = (obj, arena) -> ((NativeDataStructure)obj).ms;
                        break block4;
                    }
                    default: {
                        downConverter = (obj, arena) -> obj;
                        break block4;
                    }
                }
                break;
            }
            return downConverter;
        }
    }

    private static interface UpConverter {
        public Object convert(Object var1) throws Throwable;

        public static UpConverter forType(Class<?> type) throws ReflectiveOperationException {
            UpConverter upConverter;
            Class<?> clazz = type;
            Objects.requireNonNull(clazz);
            Class<?> clazz2 = clazz;
            int n = 0;
            block4: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, Class.class}, clazz2, n)) {
                    case 0: {
                        Class<?> cls = clazz2;
                        if (!String.class.isAssignableFrom(cls)) {
                            n = 1;
                            continue block4;
                        }
                        upConverter = ms -> ((MemorySegment)ms).getUtf8String(0L);
                        break block4;
                    }
                    case 1: {
                        Class<?> cls = clazz2;
                        if (!NativeDataStructure.class.isAssignableFrom(cls)) {
                            n = 2;
                            continue block4;
                        }
                        upConverter = new NativeUpConverter(cls);
                        break block4;
                    }
                    default: {
                        upConverter = obj -> obj;
                        break block4;
                    }
                }
                break;
            }
            return upConverter;
        }
    }

    private static class Stub {
        final MethodHandle mh;
        final DownConverter[] argConvs;
        final UpConverter retConv;

        Stub(MethodHandle mh, DownConverter[] argConvs, UpConverter retConv) {
            this.mh = mh;
            this.argConvs = argConvs;
            this.retConv = retConv;
        }

        Object invoke(Object[] args, Arena arena) throws Throwable {
            for (int i = 0; i < this.argConvs.length; ++i) {
                args[i] = args[i] == null ? MemorySegment.NULL : this.argConvs[i].convert(args[i], arena);
            }
            Object ret = this.mh.invokeWithArguments(args);
            if (MemorySegment.NULL.equals(ret)) {
                return null;
            }
            return this.retConv.convert(ret);
        }
    }

    private static class NativeUpConverter
    implements UpConverter {
        private Constructor<?> ctr;

        NativeUpConverter(Class<?> type) throws ReflectiveOperationException {
            this.ctr = type.getDeclaredConstructor(new Class[0]);
            this.ctr.setAccessible(true);
        }

        @Override
        public NativeDataStructure convert(Object obj) throws Throwable {
            NativeDataStructure nativ = (NativeDataStructure)this.ctr.newInstance(new Object[0]);
            nativ.ms = obj;
            return nativ;
        }
    }
}

