/*
 * Decompiled with CFR 0.152.
 */
package io.kojan.javadeptools.nativ;

import io.kojan.javadeptools.nativ.Native;
import io.kojan.javadeptools.nativ.NativeDataStructure;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.util.Optional;

class DynamicLinker
implements SymbolLookup {
    private static final int RTLD_LAZY = 1;
    private final DynamicLibrary handle;

    private static final DynamicLibrary dlopen(String filename, int flags) {
        return Lazy.DL.dlopen(filename, flags);
    }

    private static final DynamicSymbol dlsym(DynamicLibrary handle, String symbol) {
        return Lazy.DL.dlsym(handle, symbol);
    }

    public DynamicLinker(String lib) {
        this.handle = DynamicLinker.dlopen(lib, 1);
        if (this.handle == null) {
            throw new RuntimeException("Unable to dlopen native library: " + lib);
        }
    }

    @Override
    public Optional<MemorySegment> find(String name) {
        DynamicSymbol sym = DynamicLinker.dlsym(this.handle, name);
        if (sym == null) {
            return Optional.empty();
        }
        return Optional.of((MemorySegment)sym.ms);
    }

    private static class Lazy {
        static final LibDL DL = Native.load(LibDL.class);

        private Lazy() {
        }
    }

    private static interface LibDL {
        public DynamicLibrary dlopen(String var1, int var2);

        public DynamicSymbol dlsym(DynamicLibrary var1, String var2);
    }

    private static class DynamicLibrary
    extends NativeDataStructure {
        private DynamicLibrary() {
        }
    }

    private static class DynamicSymbol
    extends NativeDataStructure {
        private DynamicSymbol() {
        }
    }
}

