/*
 * Decompiled with CFR 0.152.
 */
package io.koalaql.postgres;

import io.koalaql.data.JdbcMappedType;
import io.koalaql.data.JdbcTypeMappings;
import io.koalaql.ddl.JsonData;
import io.koalaql.ddl.TypeMapping;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u00a8\u0006\u0002"}, d2={"PostgresTypeMappings", "Lio/koalaql/data/JdbcTypeMappings;", "postgres"})
public final class PostgresTypeMappingsKt {
    @NotNull
    public static final JdbcTypeMappings PostgresTypeMappings() {
        JdbcTypeMappings result = new JdbcTypeMappings();
        result.register(Reflection.typeOf(Instant.class), (JdbcMappedType)new JdbcMappedType<Instant>(){

            public void writeJdbc(@NotNull PreparedStatement stmt, int index, @NotNull Instant value) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                stmt.setTimestamp(index, Timestamp.from(value));
            }

            @Nullable
            public Instant readJdbc(@NotNull ResultSet rs, int index) {
                Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
                Timestamp timestamp = rs.getTimestamp(index);
                return timestamp != null ? timestamp.toInstant() : null;
            }

            @NotNull
            public <R> JdbcMappedType<R> derive(@NotNull TypeMapping<Instant, R> mapping) {
                return JdbcMappedType.DefaultImpls.derive((JdbcMappedType)this, mapping);
            }
        });
        result.register(Reflection.typeOf(JsonData.class), (JdbcMappedType)new JdbcMappedType<JsonData>(){

            public void writeJdbc(@NotNull PreparedStatement stmt, int index, @NotNull JsonData value) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                stmt.setObject(index, (Object)value.getAsString(), 1111);
            }

            @Nullable
            public JsonData readJdbc(@NotNull ResultSet rs, int index) {
                JsonData jsonData;
                Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
                String string = rs.getString(index);
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    jsonData = new JsonData(it);
                } else {
                    jsonData = null;
                }
                return jsonData;
            }

            @NotNull
            public <R> JdbcMappedType<R> derive(@NotNull TypeMapping<JsonData, R> mapping) {
                return JdbcMappedType.DefaultImpls.derive((JdbcMappedType)this, mapping);
            }
        });
        return result;
    }
}

