/*
 * Decompiled with CFR 0.152.
 */
package io.koalaql.postgres;

import io.koalaql.ddl.BIGINT;
import io.koalaql.ddl.BOOLEAN;
import io.koalaql.ddl.BaseColumnType;
import io.koalaql.ddl.ColumnType;
import io.koalaql.ddl.DATE;
import io.koalaql.ddl.DATETIME;
import io.koalaql.ddl.DECIMAL;
import io.koalaql.ddl.DOUBLE;
import io.koalaql.ddl.DataType;
import io.koalaql.ddl.ExtendedDataType;
import io.koalaql.ddl.FLOAT;
import io.koalaql.ddl.INTEGER;
import io.koalaql.ddl.IndexType;
import io.koalaql.ddl.SMALLINT;
import io.koalaql.ddl.TEXT;
import io.koalaql.ddl.TIME;
import io.koalaql.ddl.TIMESTAMP;
import io.koalaql.ddl.Table;
import io.koalaql.ddl.TableColumn;
import io.koalaql.ddl.TableName;
import io.koalaql.ddl.UnmappedDataType;
import io.koalaql.ddl.VARBINARY;
import io.koalaql.ddl.VARCHAR;
import io.koalaql.ddl.built.BuiltColumnDef;
import io.koalaql.ddl.built.BuiltNamedIndex;
import io.koalaql.ddl.diff.ChangedDefault;
import io.koalaql.ddl.diff.ColumnDiff;
import io.koalaql.ddl.diff.SchemaChange;
import io.koalaql.ddl.diff.TableDiff;
import io.koalaql.expr.Expr;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0004()*+B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J'\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00032\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010 J\u0018\u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\"\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u000fJ\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006,"}, d2={"Lio/koalaql/postgres/PostgresSchemaDiff;", "", "dbName", "", "metadata", "Ljava/sql/DatabaseMetaData;", "(Ljava/lang/String;Ljava/sql/DatabaseMetaData;)V", "getDbName", "()Ljava/lang/String;", "getMetadata", "()Ljava/sql/DatabaseMetaData;", "detectChanges", "Lio/koalaql/ddl/diff/SchemaChange;", "tables", "", "Lio/koalaql/ddl/Table;", "diffColumnType", "", "isAutoIncrement", "dataType", "Lio/koalaql/ddl/UnmappedDataType;", "info", "Lio/koalaql/postgres/PostgresSchemaDiff$ColumnTypeInfo;", "diffColumns", "", "table", "result", "Lio/koalaql/ddl/diff/TableDiff;", "diffDatetime", "name", "precision", "", "(Ljava/lang/String;Ljava/lang/Integer;Lio/koalaql/postgres/PostgresSchemaDiff$ColumnTypeInfo;)Z", "diffKeys", "diffTable", "fetchExistingPrimaryKey", "Lio/koalaql/postgres/PostgresSchemaDiff$IndexWithKeyNames;", "tableName", "Lio/koalaql/ddl/TableName;", "timeLength", "ColumnTypeInfo", "IndexPart", "IndexWithKeyNames", "PrimaryKeyPart", "postgres"})
@SourceDebugExtension(value={"SMAP\nPostgresSchemaDiff.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostgresSchemaDiff.kt\nio/koalaql/postgres/PostgresSchemaDiff\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,311:1\n1222#2,4:312\n1002#2,2:319\n1549#2:321\n1620#2,3:322\n1222#2,4:332\n1002#2,2:337\n1549#2:339\n1620#2,3:340\n1549#2:343\n1620#2,3:344\n1222#2,4:350\n1549#2:354\n1620#2,3:355\n1477#2:358\n1502#2,3:359\n1505#2,3:369\n1855#2,2:381\n215#3,2:316\n215#3:336\n216#3:347\n215#3,2:348\n215#3,2:379\n1#4:318\n361#5,7:325\n361#5,7:362\n483#5,7:372\n*S KotlinDebug\n*F\n+ 1 PostgresSchemaDiff.kt\nio/koalaql/postgres/PostgresSchemaDiff\n*L\n80#1:312,4\n184#1:319,2\n189#1:321\n189#1:322,3\n217#1:332,4\n220#1:337,2\n229#1:339\n229#1:340,3\n240#1:343\n240#1:344,3\n275#1:350,4\n278#1:354\n278#1:355,3\n278#1:358\n278#1:359,3\n278#1:369,3\n303#1:381,2\n134#1:316,2\n219#1:336\n219#1:347\n254#1:348,2\n301#1:379,2\n208#1:325,7\n278#1:362,7\n278#1:372,7\n*E\n"})
public final class PostgresSchemaDiff {
    @NotNull
    private final String dbName;
    @NotNull
    private final DatabaseMetaData metadata;

    public PostgresSchemaDiff(@NotNull String dbName, @NotNull DatabaseMetaData metadata) {
        Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        this.dbName = dbName;
        this.metadata = metadata;
    }

    @NotNull
    public final String getDbName() {
        return this.dbName;
    }

    @NotNull
    public final DatabaseMetaData getMetadata() {
        return this.metadata;
    }

    private final int timeLength(int precision) {
        return precision == 0 ? 0 : precision + 1;
    }

    private final boolean diffDatetime(String name, Integer precision, ColumnTypeInfo info) {
        return !Intrinsics.areEqual((Object)info.getName(), (Object)name) || info.getTag() != 93 || precision != null && info.getDecimalDigits() != precision.intValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean diffColumnType(boolean isAutoIncrement, UnmappedDataType<?> dataType, ColumnTypeInfo info) {
        boolean bl;
        UnmappedDataType<?> unmappedDataType = dataType;
        if (Intrinsics.areEqual(unmappedDataType, (Object)BOOLEAN.INSTANCE)) {
            if (info.getTag() == -7) return false;
            return true;
        }
        if (Intrinsics.areEqual(unmappedDataType, (Object)DOUBLE.INSTANCE)) {
            if (info.getTag() == 8) return false;
            return true;
        }
        if (Intrinsics.areEqual(unmappedDataType, (Object)FLOAT.INSTANCE)) {
            if (info.getTag() == 7) return false;
            return true;
        }
        if (Intrinsics.areEqual(unmappedDataType, (Object)TEXT.INSTANCE)) {
            if (info.getTag() == 12) return false;
            return true;
        }
        if (unmappedDataType instanceof VARCHAR) {
            if (info.getTag() != 12) return true;
            if (info.getColumnSize() == ((VARCHAR)dataType).getMaxLength()) return false;
            return true;
        }
        if (unmappedDataType instanceof DATETIME) {
            bl = this.diffDatetime("timestamp", ((DATETIME)dataType).getPrecision(), info);
            return bl;
        } else if (unmappedDataType instanceof TIMESTAMP) {
            bl = this.diffDatetime("timestamptz", ((TIMESTAMP)dataType).getPrecision(), info);
            return bl;
        } else {
            if (unmappedDataType instanceof DECIMAL) {
                if (info.getTag() != 2) return true;
                if (info.getColumnSize() != ((DECIMAL)dataType).getPrecision()) return true;
                if (info.getDecimalDigits() == ((DECIMAL)dataType).getScale()) return false;
                return true;
            }
            if (Intrinsics.areEqual(unmappedDataType, (Object)DATE.INSTANCE)) {
                if (info.getTag() == 91) return false;
                return true;
            }
            if (Intrinsics.areEqual(unmappedDataType, (Object)SMALLINT.INSTANCE)) {
                if (isAutoIncrement) {
                    if (info.getTag() != 5) return true;
                    if (Intrinsics.areEqual((Object)info.getName(), (Object)"smallserial")) return false;
                    return true;
                }
                if (info.getTag() != 5) return true;
                if (Intrinsics.areEqual((Object)info.getName(), (Object)"int2")) return false;
                return true;
            }
            if (Intrinsics.areEqual(unmappedDataType, (Object)INTEGER.INSTANCE)) {
                if (isAutoIncrement) {
                    if (info.getTag() != 4) return true;
                    if (Intrinsics.areEqual((Object)info.getName(), (Object)"serial")) return false;
                    return true;
                }
                if (info.getTag() != 4) return true;
                if (Intrinsics.areEqual((Object)info.getName(), (Object)"int4")) return false;
                return true;
            }
            if (Intrinsics.areEqual(unmappedDataType, (Object)BIGINT.INSTANCE)) {
                if (isAutoIncrement) {
                    if (info.getTag() != -5) return true;
                    if (Intrinsics.areEqual((Object)info.getName(), (Object)"bigserial")) return false;
                    return true;
                }
                if (info.getTag() != -5) return true;
                if (Intrinsics.areEqual((Object)info.getName(), (Object)"int8")) return false;
                return true;
            }
            if (unmappedDataType instanceof TIME) {
                if (info.getTag() != 92) return true;
                if (((TIME)dataType).getPrecision() == null) return false;
                int n = info.getColumnSize();
                Integer n2 = ((TIME)dataType).getPrecision();
                Intrinsics.checkNotNull((Object)n2);
                if (n == 8 + this.timeLength(n2)) return false;
                return true;
            }
            if (unmappedDataType instanceof VARBINARY) {
                if (info.getTag() != -3) return true;
                if (info.getColumnSize() == ((VARBINARY)dataType).getMaxLength()) return false;
                return true;
            }
            if (unmappedDataType instanceof ExtendedDataType) {
                return false;
            }
            if (Intrinsics.areEqual((Object)info.getName(), (Object)"json")) return false;
            return true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void diffColumns(Table table, TableDiff result) {
        void $this$associateByTo$iv;
        TableName tableName = table.getTableName();
        HashMap expectedColumnsByName = new HashMap();
        Iterable iterable = table.getColumns().includingUnused();
        boolean $i$f$associateByTo = false;
        for (Object element$iv : $this$associateByTo$iv) {
            void it;
            TableColumn tableColumn = (TableColumn)element$iv;
            Map map = expectedColumnsByName;
            boolean bl = false;
            map.put(it.getSymbol(), element$iv);
        }
        ResultSet columns = this.metadata.getColumns(this.dbName, tableName.getSchema(), tableName.getName(), null);
        while (columns.next()) {
            String string;
            String name = columns.getString("COLUMN_NAME");
            int n = columns.getInt("DATA_TYPE");
            String string2 = columns.getString("TYPE_NAME");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"columns.getString(\"TYPE_NAME\")");
            ColumnTypeInfo typeInfo = new ColumnTypeInfo(n, string2, columns.getInt("COLUMN_SIZE"), columns.getInt("DECIMAL_DIGITS"));
            TableColumn expected = (TableColumn)expectedColumnsByName.remove(name);
            if (expected == null) {
                Set set = result.getColumns().getDropped();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                set.add(name);
                continue;
            }
            BuiltColumnDef def = expected.getBuiltDef();
            boolean isAutoincrement = Intrinsics.areEqual((Object)columns.getString("IS_AUTOINCREMENT"), (Object)"YES");
            ColumnDiff diff = new ColumnDiff(expected, (ColumnType)(this.diffColumnType(isAutoincrement, def.getColumnType().getDataType(), typeInfo) ? new BaseColumnType((DataType)def.getColumnType().getDataType()) : null), Intrinsics.areEqual((Object)(string = columns.getString("IS_NULLABLE")), (Object)"YES") ? (def.getNotNull() ? Boolean.valueOf(def.getNotNull()) : null) : (Intrinsics.areEqual((Object)string, (Object)"NO") ? (!def.getNotNull() ? Boolean.valueOf(def.getNotNull()) : null) : null), columns.getString("COLUMN_DEF") == null ? (def.getDefault() != null ? new ChangedDefault(def.getDefault()) : null) : (def.getDefault() == null && !isAutoincrement ? new ChangedDefault(def.getDefault()) : null), null);
            if (diff.doesNothing()) continue;
            Map map = result.getColumns().getAltered();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            map.put(name, diff);
        }
        Map $this$forEach$iv = expectedColumnsByName;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String name = (String)entry.getKey();
            TableColumn def = (TableColumn)entry.getValue();
            result.getColumns().getCreated().put(name, def);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final IndexWithKeyNames fetchExistingPrimaryKey(TableName tableName) {
        IndexWithKeyNames indexWithKeyNames;
        ArrayList<PrimaryKeyPart> arrayList;
        ArrayList<PrimaryKeyPart> arrayList2;
        ResultSet pkResults = this.metadata.getPrimaryKeys(this.dbName, tableName.getSchema(), tableName.getName());
        ArrayList<PrimaryKeyPart> pkParts = new ArrayList<PrimaryKeyPart>();
        while (pkResults.next()) {
            String string = pkResults.getString("PK_NAME");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pkResults.getString(\"PK_NAME\")");
            int n = pkResults.getInt("KEY_SEQ");
            String string2 = pkResults.getString("COLUMN_NAME");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pkResults.getString(\"COLUMN_NAME\")");
            pkParts.add(new PrimaryKeyPart(string, n, string2));
        }
        ArrayList<PrimaryKeyPart> it = arrayList2 = pkParts;
        boolean bl = false;
        ArrayList<PrimaryKeyPart> arrayList3 = arrayList = !((Collection)it).isEmpty() ? arrayList2 : null;
        if (arrayList != null) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ArrayList<PrimaryKeyPart> parts = arrayList;
            boolean bl2 = false;
            Iterable $this$sortBy$iv = parts;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        PrimaryKeyPart it = (PrimaryKeyPart)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getOrdinal());
                        it = (PrimaryKeyPart)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getOrdinal()));
                    }
                });
            }
            $this$sortBy$iv = parts;
            IndexType indexType = IndexType.PRIMARY;
            String string = ((PrimaryKeyPart)CollectionsKt.first((List)parts)).getName();
            boolean $i$f$map = false;
            void var12_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                PrimaryKeyPart primaryKeyPart = (PrimaryKeyPart)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it2.getColumnName());
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            IndexType indexType2 = indexType;
            String string3 = string;
            indexWithKeyNames = new IndexWithKeyNames(string3, indexType2, list);
        } else {
            indexWithKeyNames = null;
        }
        return indexWithKeyNames;
    }

    /*
     * WARNING - void declaration
     */
    private final void diffKeys(Table table, TableDiff result) {
        Map.Entry entry;
        Map.Entry element$iv;
        void destination$iv;
        void $this$associateByTo$iv;
        Iterable infos;
        Object answer$iv;
        Map $this$getOrPut$iv;
        TableName tableName = table.getTableName();
        IndexWithKeyNames existingPrimaryKey = this.fetchExistingPrimaryKey(tableName);
        ResultSet indexResults = this.metadata.getIndexInfo(this.dbName, tableName.getSchema(), tableName.getName(), false, false);
        HashMap indexInfosByName = new HashMap();
        while (indexResults.next()) {
            Object object;
            String name = indexResults.getString("INDEX_NAME");
            if (name == null) continue;
            IndexWithKeyNames indexWithKeyNames = existingPrimaryKey;
            if (Intrinsics.areEqual((Object)name, (Object)(indexWithKeyNames != null ? indexWithKeyNames.getName() : null))) continue;
            Map map = indexInfosByName;
            String key$iv = name;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            infos = (ArrayList)object;
            boolean bl = !indexResults.getBoolean("NON_UNIQUE");
            int n = indexResults.getInt("ORDINAL_POSITION");
            String string = indexResults.getString("COLUMN_NAME");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"indexResults.getString(\"COLUMN_NAME\")");
            ((ArrayList)infos).add(new IndexPart(bl, n, string));
        }
        infos = table.getIndexes();
        $this$getOrPut$iv = new HashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv2 : $this$associateByTo$iv) {
            void it;
            answer$iv = (BuiltNamedIndex)element$iv2;
            void var31_24 = destination$iv;
            boolean bl = false;
            var31_24.put(it.getName(), element$iv2);
        }
        HashMap expectedIndexesByName = (HashMap)destination$iv;
        Map $this$forEach$iv = indexInfosByName;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Collection<String> collection;
            Iterable $this$mapTo$iv$iv2;
            void $this$map$iv2;
            entry = element$iv = iterator.next();
            boolean bl = false;
            String name = (String)entry.getKey();
            ArrayList parts = (ArrayList)entry.getValue();
            List $this$sortBy$iv = parts;
            boolean $i$f$sortBy22 = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        IndexPart it = (IndexPart)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getOrdinal());
                        it = (IndexPart)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getOrdinal()));
                    }
                });
            }
            Iterable $i$f$sortBy22 = parts;
            IndexType indexType = ((IndexPart)CollectionsKt.first((List)parts)).getUnique() ? IndexType.UNIQUE : IndexType.INDEX;
            String string = name;
            boolean $i$f$map = false;
            void var21_33 = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                IndexPart indexPart = (IndexPart)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getColumnName());
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            IndexType indexType2 = indexType;
            String string2 = string;
            IndexWithKeyNames existing = new IndexWithKeyNames(string2, indexType2, list);
            BuiltNamedIndex expected = (BuiltNamedIndex)expectedIndexesByName.remove(name);
            if (expected == null) {
                result.getIndexes().getDropped().add(name);
                continue;
            }
            $this$mapTo$iv$iv2 = expected.getDef().getKeys().getKeys();
            indexType = expected.getDef().getType();
            string = expected.getName();
            boolean $i$f$map2 = false;
            void $i$f$mapTo22 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void expr;
                Expr expr2 = (Expr)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                if (!(expr instanceof TableColumn)) {
                    throw new IllegalStateException("not implemented".toString());
                }
                collection.add(((TableColumn)expr).getSymbol());
            }
            String string3 = string;
            IndexType indexType3 = indexType;
            collection = (List)destination$iv$iv2;
            Collection<String> collection2 = collection;
            IndexWithKeyNames converted = new IndexWithKeyNames(string3, indexType3, (List<String>)collection2);
            if (existing.equivalent(converted)) continue;
            result.getIndexes().getAltered().put(name, expected.getDef());
        }
        $this$forEach$iv = expectedIndexesByName;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            String name = (String)entry.getKey();
            BuiltNamedIndex it = (BuiltNamedIndex)entry.getValue();
            result.getIndexes().getCreated().put(name, it.getDef());
        }
    }

    @NotNull
    public final TableDiff diffTable(@NotNull Table table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        TableDiff result = new TableDiff(table, null, null, 6, null);
        this.diffColumns(table, result);
        this.diffKeys(table, result);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SchemaChange detectChanges(@NotNull List<? extends Table> tables) {
        void it;
        void destination$iv;
        void $this$associateByTo$iv;
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        SchemaChange diff = new SchemaChange(null, 1, null);
        Iterable iterable = tables;
        Map map = new HashMap();
        boolean $i$f$associateByTo2 = false;
        Object object = $this$associateByTo$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            Table table = (Table)element$iv;
            void var22_12 = destination$iv;
            boolean bl = false;
            var22_12.put(it.getTableName(), element$iv);
        }
        HashMap toCreate = (HashMap)destination$iv;
        if (!(tables.size() == toCreate.size())) {
            void $this$filterValues$iv;
            void $this$groupByTo$iv$iv;
            Iterator<Map.Entry<TableName, List>> $this$groupBy$iv;
            TableName it2;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            boolean $i$a$-check-PostgresSchemaDiff$detectChanges$22 = false;
            Iterable $i$f$associateByTo2 = tables;
            object = new StringBuilder().append("Duplicate table names ");
            boolean $i$f$map = false;
            it = $this$map$iv;
            Iterator<Map.Entry<TableName, List>> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Table table = (Table)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it2.getTableName());
            }
            $this$map$iv = (List)((Object)destination$iv$iv);
            boolean $i$f$groupBy = false;
            $this$mapTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                it2 = (TableName)element$iv$iv;
                boolean bl = false;
                TableName key$iv$iv = it2;
                Iterator<Map.Entry<TableName, List>> $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                List it3 = (List)entry$iv.getValue();
                boolean bl = false;
                if (!(it3.size() > 1)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            String $i$a$-check-PostgresSchemaDiff$detectChanges$22 = ((StringBuilder)object).append(((Map)result$iv).keySet()).toString();
            throw new IllegalStateException($i$a$-check-PostgresSchemaDiff$detectChanges$22.toString());
        }
        ArrayList<Table> toDiff = new ArrayList<Table>();
        String[] $this$filterValues$iv = new String[]{"TABLE"};
        ResultSet rs = this.metadata.getTables(this.dbName, null, null, $this$filterValues$iv);
        while (rs.next()) {
            Table it4;
            Object it5 = object = rs.getString("TABLE_SCHEM");
            boolean bl = false;
            Object schema = !Intrinsics.areEqual((Object)it5, (Object)"public") ? object : null;
            String name = rs.getString("TABLE_NAME");
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            if ((Table)toCreate.remove(new TableName((String)schema, name)) == null) continue;
            boolean bl3 = false;
            toDiff.add(it4);
        }
        Object $this$forEach$iv = toCreate;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it4 = element$iv = iterator.next();
            boolean bl = false;
            TableName name = (TableName)it4.getKey();
            Table table = (Table)it4.getValue();
            diff.getTables().getCreated().put(name, table);
        }
        $this$forEach$iv = toDiff;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv = iterator.next();
            Table table = (Table)element$iv;
            boolean bl = false;
            TableDiff tableDiff = this.diffTable(table);
            if (tableDiff.isEmpty()) continue;
            diff.getTables().getAltered().put(table.getTableName(), tableDiff);
        }
        return diff;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0019"}, d2={"Lio/koalaql/postgres/PostgresSchemaDiff$ColumnTypeInfo;", "", "tag", "", "name", "", "columnSize", "decimalDigits", "(ILjava/lang/String;II)V", "getColumnSize", "()I", "getDecimalDigits", "getName", "()Ljava/lang/String;", "getTag", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "postgres"})
    private static final class ColumnTypeInfo {
        private final int tag;
        @NotNull
        private final String name;
        private final int columnSize;
        private final int decimalDigits;

        public ColumnTypeInfo(int tag, @NotNull String name, int columnSize, int decimalDigits) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.tag = tag;
            this.name = name;
            this.columnSize = columnSize;
            this.decimalDigits = decimalDigits;
        }

        public final int getTag() {
            return this.tag;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getColumnSize() {
            return this.columnSize;
        }

        public final int getDecimalDigits() {
            return this.decimalDigits;
        }

        public final int component1() {
            return this.tag;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        public final int component3() {
            return this.columnSize;
        }

        public final int component4() {
            return this.decimalDigits;
        }

        @NotNull
        public final ColumnTypeInfo copy(int tag, @NotNull String name, int columnSize, int decimalDigits) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new ColumnTypeInfo(tag, name, columnSize, decimalDigits);
        }

        public static /* synthetic */ ColumnTypeInfo copy$default(ColumnTypeInfo columnTypeInfo, int n, String string, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = columnTypeInfo.tag;
            }
            if ((n4 & 2) != 0) {
                string = columnTypeInfo.name;
            }
            if ((n4 & 4) != 0) {
                n2 = columnTypeInfo.columnSize;
            }
            if ((n4 & 8) != 0) {
                n3 = columnTypeInfo.decimalDigits;
            }
            return columnTypeInfo.copy(n, string, n2, n3);
        }

        @NotNull
        public String toString() {
            return "ColumnTypeInfo(tag=" + this.tag + ", name=" + this.name + ", columnSize=" + this.columnSize + ", decimalDigits=" + this.decimalDigits + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.tag);
            result = result * 31 + this.name.hashCode();
            result = result * 31 + Integer.hashCode(this.columnSize);
            result = result * 31 + Integer.hashCode(this.decimalDigits);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ColumnTypeInfo)) {
                return false;
            }
            ColumnTypeInfo columnTypeInfo = (ColumnTypeInfo)other;
            if (this.tag != columnTypeInfo.tag) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)columnTypeInfo.name)) {
                return false;
            }
            if (this.columnSize != columnTypeInfo.columnSize) {
                return false;
            }
            return this.decimalDigits == columnTypeInfo.decimalDigits;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J-\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0000J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lio/koalaql/postgres/PostgresSchemaDiff$IndexWithKeyNames;", "", "name", "", "type", "Lio/koalaql/ddl/IndexType;", "columns", "", "(Ljava/lang/String;Lio/koalaql/ddl/IndexType;Ljava/util/List;)V", "getColumns", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "getType", "()Lio/koalaql/ddl/IndexType;", "component1", "component2", "component3", "copy", "equals", "", "other", "equivalent", "hashCode", "", "toString", "postgres"})
    @SourceDebugExtension(value={"SMAP\nPostgresSchemaDiff.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostgresSchemaDiff.kt\nio/koalaql/postgres/PostgresSchemaDiff$IndexWithKeyNames\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,311:1\n1864#2,3:312\n*S KotlinDebug\n*F\n+ 1 PostgresSchemaDiff.kt\nio/koalaql/postgres/PostgresSchemaDiff$IndexWithKeyNames\n*L\n160#1:312,3\n*E\n"})
    private static final class IndexWithKeyNames {
        @NotNull
        private final String name;
        @NotNull
        private final IndexType type;
        @NotNull
        private final List<String> columns;

        public IndexWithKeyNames(@NotNull String name, @NotNull IndexType type, @NotNull List<String> columns) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            this.name = name;
            this.type = type;
            this.columns = columns;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final IndexType getType() {
            return this.type;
        }

        @NotNull
        public final List<String> getColumns() {
            return this.columns;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equivalent(@NotNull IndexWithKeyNames other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (this.type != other.type) {
                return false;
            }
            if (this.columns.size() != other.columns.size()) {
                return false;
            }
            Iterable $this$forEachIndexed$iv = this.columns;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void col;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int ix = n;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)col, (Object)other.columns.get(ix))) continue;
                return false;
            }
            return true;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final IndexType component2() {
            return this.type;
        }

        @NotNull
        public final List<String> component3() {
            return this.columns;
        }

        @NotNull
        public final IndexWithKeyNames copy(@NotNull String name, @NotNull IndexType type, @NotNull List<String> columns) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            return new IndexWithKeyNames(name, type, columns);
        }

        public static /* synthetic */ IndexWithKeyNames copy$default(IndexWithKeyNames indexWithKeyNames, String string, IndexType indexType, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = indexWithKeyNames.name;
            }
            if ((n & 2) != 0) {
                indexType = indexWithKeyNames.type;
            }
            if ((n & 4) != 0) {
                list = indexWithKeyNames.columns;
            }
            return indexWithKeyNames.copy(string, indexType, list);
        }

        @NotNull
        public String toString() {
            return "IndexWithKeyNames(name=" + this.name + ", type=" + this.type + ", columns=" + this.columns + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.type.hashCode();
            result = result * 31 + ((Object)this.columns).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IndexWithKeyNames)) {
                return false;
            }
            IndexWithKeyNames indexWithKeyNames = (IndexWithKeyNames)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)indexWithKeyNames.name)) {
                return false;
            }
            if (this.type != indexWithKeyNames.type) {
                return false;
            }
            return Intrinsics.areEqual(this.columns, indexWithKeyNames.columns);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lio/koalaql/postgres/PostgresSchemaDiff$PrimaryKeyPart;", "", "name", "", "ordinal", "", "columnName", "(Ljava/lang/String;ILjava/lang/String;)V", "getColumnName", "()Ljava/lang/String;", "getName", "getOrdinal", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "postgres"})
    private static final class PrimaryKeyPart {
        @NotNull
        private final String name;
        private final int ordinal;
        @NotNull
        private final String columnName;

        public PrimaryKeyPart(@NotNull String name, int ordinal, @NotNull String columnName) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
            this.name = name;
            this.ordinal = ordinal;
            this.columnName = columnName;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getOrdinal() {
            return this.ordinal;
        }

        @NotNull
        public final String getColumnName() {
            return this.columnName;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final int component2() {
            return this.ordinal;
        }

        @NotNull
        public final String component3() {
            return this.columnName;
        }

        @NotNull
        public final PrimaryKeyPart copy(@NotNull String name, int ordinal, @NotNull String columnName) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
            return new PrimaryKeyPart(name, ordinal, columnName);
        }

        public static /* synthetic */ PrimaryKeyPart copy$default(PrimaryKeyPart primaryKeyPart, String string, int n, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = primaryKeyPart.name;
            }
            if ((n2 & 2) != 0) {
                n = primaryKeyPart.ordinal;
            }
            if ((n2 & 4) != 0) {
                string2 = primaryKeyPart.columnName;
            }
            return primaryKeyPart.copy(string, n, string2);
        }

        @NotNull
        public String toString() {
            return "PrimaryKeyPart(name=" + this.name + ", ordinal=" + this.ordinal + ", columnName=" + this.columnName + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Integer.hashCode(this.ordinal);
            result = result * 31 + this.columnName.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PrimaryKeyPart)) {
                return false;
            }
            PrimaryKeyPart primaryKeyPart = (PrimaryKeyPart)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)primaryKeyPart.name)) {
                return false;
            }
            if (this.ordinal != primaryKeyPart.ordinal) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.columnName, (Object)primaryKeyPart.columnName);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lio/koalaql/postgres/PostgresSchemaDiff$IndexPart;", "", "unique", "", "ordinal", "", "columnName", "", "(ZILjava/lang/String;)V", "getColumnName", "()Ljava/lang/String;", "getOrdinal", "()I", "getUnique", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "postgres"})
    private static final class IndexPart {
        private final boolean unique;
        private final int ordinal;
        @NotNull
        private final String columnName;

        public IndexPart(boolean unique, int ordinal, @NotNull String columnName) {
            Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
            this.unique = unique;
            this.ordinal = ordinal;
            this.columnName = columnName;
        }

        public final boolean getUnique() {
            return this.unique;
        }

        public final int getOrdinal() {
            return this.ordinal;
        }

        @NotNull
        public final String getColumnName() {
            return this.columnName;
        }

        public final boolean component1() {
            return this.unique;
        }

        public final int component2() {
            return this.ordinal;
        }

        @NotNull
        public final String component3() {
            return this.columnName;
        }

        @NotNull
        public final IndexPart copy(boolean unique, int ordinal, @NotNull String columnName) {
            Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
            return new IndexPart(unique, ordinal, columnName);
        }

        public static /* synthetic */ IndexPart copy$default(IndexPart indexPart, boolean bl, int n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bl = indexPart.unique;
            }
            if ((n2 & 2) != 0) {
                n = indexPart.ordinal;
            }
            if ((n2 & 4) != 0) {
                string = indexPart.columnName;
            }
            return indexPart.copy(bl, n, string);
        }

        @NotNull
        public String toString() {
            return "IndexPart(unique=" + this.unique + ", ordinal=" + this.ordinal + ", columnName=" + this.columnName + ')';
        }

        public int hashCode() {
            int n = this.unique ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int result = n;
            result = result * 31 + Integer.hashCode(this.ordinal);
            result = result * 31 + this.columnName.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IndexPart)) {
                return false;
            }
            IndexPart indexPart = (IndexPart)other;
            if (this.unique != indexPart.unique) {
                return false;
            }
            if (this.ordinal != indexPart.ordinal) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.columnName, (Object)indexPart.columnName);
        }
    }
}

