/*
 * Decompiled with CFR 0.152.
 */
package io.koalaql.postgres;

import io.koalaql.expr.Literal;
import io.koalaql.identifier.Named;
import io.koalaql.sql.SqlEscapes;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.postgresql.core.Utils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u0003\u001a\u00020\bH\u0016J2\u0010\t\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0010\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\fH\u0016\u00a8\u0006\r"}, d2={"Lio/koalaql/postgres/PostgresDdlEscapes;", "Lio/koalaql/sql/SqlEscapes;", "()V", "identifier", "", "sql", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Lio/koalaql/identifier/Named;", "literal", "params", "", "Lio/koalaql/expr/Literal;", "postgres"})
public final class PostgresDdlEscapes
implements SqlEscapes {
    @NotNull
    public static final PostgresDdlEscapes INSTANCE = new PostgresDdlEscapes();

    private PostgresDdlEscapes() {
    }

    public void identifier(@NotNull StringBuilder sql2, @NotNull Named identifier) {
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Utils.escapeIdentifier((StringBuilder)sql2, (String)identifier.getName());
    }

    public void literal(@NotNull StringBuilder sql2, @NotNull List<Literal<?>> params, @NotNull Literal<?> literal) {
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter(literal, (String)"literal");
        if (literal.getValue() == null) {
            sql2.append("NULL");
            return;
        }
        KType kType = literal.getType();
        if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Byte.TYPE))) {
            Object object = literal.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Byte");
            sql2.append(String.valueOf(((Byte)object).byteValue()));
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Short.TYPE))) {
            Object object = literal.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Short");
            sql2.append(String.valueOf(((Short)object).shortValue()));
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Integer.TYPE))) {
            Object object = literal.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
            sql2.append(String.valueOf((Integer)object));
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Long.TYPE))) {
            Object object = literal.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
            sql2.append(String.valueOf((Long)object));
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Float.TYPE))) {
            Object object = literal.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
            sql2.append(String.valueOf(((Float)object).floatValue()));
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Double.TYPE))) {
            Object object = literal.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
            sql2.append(String.valueOf((Double)object));
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(String.class))) {
            sql2.append("'");
            Object object = literal.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            Utils.escapeLiteral((StringBuilder)sql2, (String)((String)object), (boolean)true);
            sql2.append("'");
        } else {
            throw new IllegalStateException((literal.getType() + " literals are not supported in Postgres DDL").toString());
        }
    }
}

