/*
 * Decompiled with CFR 0.152.
 */
package io.koalaql.postgres;

import io.koalaql.Assignment;
import io.koalaql.ddl.BIGINT;
import io.koalaql.ddl.INTEGER;
import io.koalaql.ddl.IndexType;
import io.koalaql.ddl.SMALLINT;
import io.koalaql.ddl.Table;
import io.koalaql.ddl.TableColumn;
import io.koalaql.ddl.UnmappedDataType;
import io.koalaql.ddl.built.BuiltColumnDef;
import io.koalaql.ddl.built.BuiltColumnDefault;
import io.koalaql.ddl.built.BuiltIndexDef;
import io.koalaql.ddl.built.BuiltNamedIndex;
import io.koalaql.ddl.built.ColumnDefaultExpr;
import io.koalaql.ddl.built.ColumnDefaultValue;
import io.koalaql.ddl.diff.SchemaChange;
import io.koalaql.dialect.ExpressionCompiler;
import io.koalaql.dialect.SqlDialect;
import io.koalaql.dialect.SqlTextBuildersKt;
import io.koalaql.expr.Column;
import io.koalaql.expr.Expr;
import io.koalaql.expr.Literal;
import io.koalaql.expr.Ordinal;
import io.koalaql.expr.QuasiExpr;
import io.koalaql.expr.Reference;
import io.koalaql.expr.SelectedExpr;
import io.koalaql.expr.built.BuiltAggregatable;
import io.koalaql.postgres.PostgresDialectKt;
import io.koalaql.query.Cte;
import io.koalaql.query.Distinctness;
import io.koalaql.query.EmptyRelation;
import io.koalaql.query.LockMode;
import io.koalaql.query.OnConflictOrDuplicateAction;
import io.koalaql.query.Relation;
import io.koalaql.query.Subquery;
import io.koalaql.query.TableRelation;
import io.koalaql.query.Values;
import io.koalaql.query.WithType;
import io.koalaql.query.built.BuiltDelete;
import io.koalaql.query.built.BuiltDml;
import io.koalaql.query.built.BuiltInsert;
import io.koalaql.query.built.BuiltJoin;
import io.koalaql.query.built.BuiltQueryBody;
import io.koalaql.query.built.BuiltRelation;
import io.koalaql.query.built.BuiltSelectQuery;
import io.koalaql.query.built.BuiltSetOperation;
import io.koalaql.query.built.BuiltSubquery;
import io.koalaql.query.built.BuiltUpdate;
import io.koalaql.query.built.BuiltValuesQuery;
import io.koalaql.query.built.BuiltWith;
import io.koalaql.sql.IdentifierQuoteStyle;
import io.koalaql.sql.NameRegistry;
import io.koalaql.sql.Scope;
import io.koalaql.sql.SqlPrefix;
import io.koalaql.sql.SqlText;
import io.koalaql.sql.SqlTextBuilder;
import io.koalaql.window.CurrentRow;
import io.koalaql.window.Following;
import io.koalaql.window.FrameClauseType;
import io.koalaql.window.FrameRangeMarker;
import io.koalaql.window.LabeledWindow;
import io.koalaql.window.Preceding;
import io.koalaql.window.Unbounded;
import io.koalaql.window.WindowLabel;
import io.koalaql.window.built.BuiltWindow;
import io.koalaql.window.built.WindowBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u001c\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J \u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a8\u0006\u001e"}, d2={"Lio/koalaql/postgres/PostgresDialect;", "Lio/koalaql/dialect/SqlDialect;", "()V", "compile", "Lio/koalaql/sql/SqlText;", "dml", "Lio/koalaql/query/built/BuiltDml;", "compileCreateTable", "", "sql", "Lio/koalaql/sql/SqlTextBuilder;", "table", "Lio/koalaql/ddl/Table;", "compileDataType", "type", "Lio/koalaql/ddl/UnmappedDataType;", "compileDefaultExpr", "expr", "Lio/koalaql/expr/Expr;", "compileIndexDef", "name", "", "def", "Lio/koalaql/ddl/built/BuiltIndexDef;", "compileSerialType", "ddl", "", "change", "Lio/koalaql/ddl/diff/SchemaChange;", "Compilation", "postgres"})
public final class PostgresDialect
implements SqlDialect {
    private final void compileDefaultExpr(SqlTextBuilder sql, Expr<?> expr) {
        Expr<?> expr2 = expr;
        if (expr2 instanceof Literal) {
            sql.addLiteral((Literal)expr);
        } else if (expr2 instanceof Column) {
            sql.addIdentifier(((Column)expr).getSymbol());
        } else {
            String string = "not implemented";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    private final void compileDataType(SqlTextBuilder sql, UnmappedDataType<?> type) {
        sql.addSql(PostgresDialectKt.access$toRawSql(type));
    }

    private final void compileSerialType(SqlTextBuilder sql, UnmappedDataType<?> type) {
        UnmappedDataType<?> unmappedDataType = type;
        if (Intrinsics.areEqual(unmappedDataType, (Object)SMALLINT.INSTANCE)) {
            sql.addSql("SMALLSERIAL");
        } else if (Intrinsics.areEqual(unmappedDataType, (Object)INTEGER.INSTANCE)) {
            sql.addSql("SERIAL");
        } else if (Intrinsics.areEqual(unmappedDataType, (Object)BIGINT.INSTANCE)) {
            sql.addSql("BIGSERIAL");
        } else {
            sql.addError(Intrinsics.stringPlus((String)"no serial type corresponds to ", type));
        }
    }

    private final void compileIndexDef(SqlTextBuilder sql, String name, BuiltIndexDef def) {
        String string;
        sql.addSql("CONSTRAINT ");
        sql.addIdentifier(name);
        IndexType indexType = def.getType();
        int n = WhenMappings.$EnumSwitchMapping$0[indexType.ordinal()];
        switch (n) {
            case 1: {
                string = " PRIMARY KEY";
                break;
            }
            case 2: {
                string = " UNIQUE";
                break;
            }
            case 3: {
                string = " INDEX";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        sql.addSql(string);
        sql.addSql(" ");
        SqlTextBuilder.parenthesize$default((SqlTextBuilder)sql, (boolean)false, (Function0)((Function0)new Function0<Unit>(sql, def, this){
            final /* synthetic */ SqlTextBuilder $sql;
            final /* synthetic */ BuiltIndexDef $def;
            final /* synthetic */ PostgresDialect this$0;
            {
                this.$sql = $sql;
                this.$def = $def;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$sql.prefix("", ", ").forEach((Iterable)this.$def.getKeys().getKeys(), (Function1)new Function1<Expr<?>, Unit>(this.this$0, this.$sql){
                    final /* synthetic */ PostgresDialect this$0;
                    final /* synthetic */ SqlTextBuilder $sql;
                    {
                        this.this$0 = $receiver;
                        this.$sql = $sql;
                        super(1);
                    }

                    public final void invoke(@NotNull Expr<?> key) {
                        Intrinsics.checkNotNullParameter(key, (String)"key");
                        PostgresDialect.access$compileDefaultExpr(this.this$0, this.$sql, key);
                    }
                });
            }
        }), (int)1, null);
    }

    private final void compileCreateTable(SqlTextBuilder sql, Table table) {
        sql.addSql("CREATE TABLE IF NOT EXISTS ");
        sql.addIdentifier(table.getTableName());
        SqlTextBuilder.parenthesize$default((SqlTextBuilder)sql, (boolean)false, (Function0)((Function0)new Function0<Unit>(sql, table, this){
            final /* synthetic */ SqlTextBuilder $sql;
            final /* synthetic */ Table $table;
            final /* synthetic */ PostgresDialect this$0;
            {
                this.$sql = $sql;
                this.$table = $table;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                SqlTextBuilder sqlTextBuilder;
                Object object;
                SqlPrefix comma = this.$sql.prefix("\n", ",\n");
                comma.forEach((Iterable)this.$table.getColumns().includingUnused(), (Function1)new Function1<TableColumn<?>, Unit>(this.$sql, this.this$0){
                    final /* synthetic */ SqlTextBuilder $sql;
                    final /* synthetic */ PostgresDialect this$0;
                    {
                        this.$sql = $sql;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull TableColumn<?> it) {
                        BuiltColumnDefault builtColumnDefault;
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        BuiltColumnDef def = it.getBuiltDef();
                        this.$sql.addIdentifier(it.getSymbol());
                        this.$sql.addSql(" ");
                        if (def.getAutoIncrement()) {
                            PostgresDialect.access$compileSerialType(this.this$0, this.$sql, def.getColumnType().getDataType());
                        } else {
                            PostgresDialect.access$compileDataType(this.this$0, this.$sql, def.getColumnType().getDataType());
                        }
                        if (def.getNotNull()) {
                            this.$sql.addSql(" NOT NULL");
                        }
                        if ((builtColumnDefault = def.getDefault()) != null) {
                            Expr expr;
                            BuiltColumnDefault builtColumnDefault2 = builtColumnDefault;
                            SqlTextBuilder sqlTextBuilder = this.$sql;
                            PostgresDialect postgresDialect = this.this$0;
                            boolean bl = false;
                            boolean bl2 = false;
                            BuiltColumnDefault builtColumnDefault3 = builtColumnDefault2;
                            boolean bl3 = false;
                            BuiltColumnDefault builtColumnDefault4 = builtColumnDefault3;
                            if (builtColumnDefault4 instanceof ColumnDefaultExpr) {
                                expr = ((ColumnDefaultExpr)builtColumnDefault3).getExpr();
                            } else if (builtColumnDefault4 instanceof ColumnDefaultValue) {
                                expr = (Expr)new Literal(def.getColumnType().getType(), ((ColumnDefaultValue)builtColumnDefault3).getValue());
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                            Expr finalExpr = expr;
                            sqlTextBuilder.addSql(" DEFAULT ");
                            PostgresDialect.access$compileDefaultExpr(postgresDialect, sqlTextBuilder, finalExpr);
                        }
                    }
                });
                Object object2 = this.$table.getPrimaryKey();
                if (object2 != null) {
                    object = object2;
                    sqlTextBuilder = this.$sql;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object pk = object;
                    boolean bl3 = false;
                    comma.next((Function0)new Function0<Unit>(sqlTextBuilder, pk){
                        final /* synthetic */ SqlTextBuilder $sql;
                        final /* synthetic */ BuiltNamedIndex $pk;
                        {
                            this.$sql = $sql;
                            this.$pk = $pk;
                            super(0);
                        }

                        public final void invoke() {
                            this.$sql.addSql("CONSTRAINT ");
                            this.$sql.addIdentifier(this.$pk.getName());
                            this.$sql.addSql(" PRIMARY KEY (");
                            this.$sql.prefix("", ", ").forEach((Iterable)this.$pk.getDef().getKeys().getKeys(), (Function1)new Function1<Expr<?>, Unit>(this.$sql){
                                final /* synthetic */ SqlTextBuilder $sql;
                                {
                                    this.$sql = $sql;
                                    super(1);
                                }

                                public final void invoke(@NotNull Expr<?> it) {
                                    Intrinsics.checkNotNullParameter(it, (String)"it");
                                    Expr<?> expr = it;
                                    if (!(expr instanceof TableColumn)) {
                                        String string = "expression keys unsupported";
                                        boolean bl = false;
                                        throw (Throwable)new IllegalStateException(string.toString());
                                    }
                                    this.$sql.addIdentifier(((TableColumn)it).getSymbol());
                                }
                            });
                            this.$sql.addSql(")");
                        }
                    });
                }
                object2 = this.$table.getIndexes();
                object = this.this$0;
                sqlTextBuilder = this.$sql;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    BuiltNamedIndex index = (BuiltNamedIndex)element$iv;
                    boolean bl = false;
                    comma.next((Function0)new Function0<Unit>((PostgresDialect)object, sqlTextBuilder, index){
                        final /* synthetic */ PostgresDialect this$0;
                        final /* synthetic */ SqlTextBuilder $sql;
                        final /* synthetic */ BuiltNamedIndex $index;
                        {
                            this.this$0 = $receiver;
                            this.$sql = $sql;
                            this.$index = $index;
                            super(0);
                        }

                        public final void invoke() {
                            PostgresDialect.access$compileIndexDef(this.this$0, this.$sql, this.$index.getName(), this.$index.getDef());
                        }
                    });
                }
                this.$sql.addSql("\n");
            }
        }), (int)1, null);
    }

    @NotNull
    public List<SqlText> ddl(@NotNull SchemaChange change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        boolean bl = false;
        List results = new ArrayList();
        Map $this$forEach$iv = change.getTables().getCreated();
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl2 = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$_u24__u24$table = element$iv = iterator.next();
            boolean bl3 = false;
            Map.Entry entry = $dstr$_u24__u24$table;
            boolean bl4 = false;
            Table table = (Table)entry.getValue();
            SqlTextBuilder sql = new SqlTextBuilder(IdentifierQuoteStyle.DOUBLE);
            this.compileCreateTable(sql, table);
            results.add(sql.toSql());
        }
        return results;
    }

    @Nullable
    public SqlText compile(@NotNull BuiltDml dml) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)dml, (String)"dml");
        NameRegistry registry = new NameRegistry();
        Scope scope = new Scope(registry, null, 2, null);
        Compilation compilation = new Compilation(scope, null, 2, null);
        dml.populateScope(scope);
        BuiltDml builtDml = dml;
        if (builtDml instanceof BuiltSelectQuery) {
            compilation.compileSelect(CollectionsKt.emptyList(), (BuiltSelectQuery)dml);
            bl = true;
        } else if (builtDml instanceof BuiltValuesQuery) {
            bl = compilation.compileValues((BuiltValuesQuery)dml);
        } else if (builtDml instanceof BuiltInsert) {
            bl = compilation.compileInsert((BuiltInsert)dml);
        } else if (builtDml instanceof BuiltUpdate) {
            compilation.compileUpdate((BuiltUpdate)dml);
            bl = true;
        } else if (builtDml instanceof BuiltDelete) {
            compilation.compileDelete((BuiltDelete)dml);
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        boolean nonEmpty = bl;
        return nonEmpty ? compilation.getSql().toSql() : (SqlText)null;
    }

    public static final /* synthetic */ void access$compileDefaultExpr(PostgresDialect $this, SqlTextBuilder sql, Expr expr) {
        $this.compileDefaultExpr(sql, expr);
    }

    public static final /* synthetic */ void access$compileSerialType(PostgresDialect $this, SqlTextBuilder sql, UnmappedDataType type) {
        $this.compileSerialType(sql, type);
    }

    public static final /* synthetic */ void access$compileDataType(PostgresDialect $this, SqlTextBuilder sql, UnmappedDataType type) {
        $this.compileDataType(sql, type);
    }

    public static final /* synthetic */ void access$compileIndexDef(PostgresDialect $this, SqlTextBuilder sql, String name, BuiltIndexDef def) {
        $this.compileIndexDef(sql, name, def);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u000fJ\u0012\u0010\u0011\u001a\u00020\f2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010\u001d\u001a\u00020\f2\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0\u001fJ \u0010!\u001a\u00020\u000e2\u0010\u0010\"\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0\u001f2\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020\f2\u0006\u0010$\u001a\u00020'J\u001a\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020*2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,J\u0012\u0010-\u001a\u00020\f2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030/J\u000e\u00100\u001a\u00020\f2\u0006\u00101\u001a\u000202J \u00103\u001a\u00020\f2\u0010\u0010\"\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0\u001f2\u0006\u00104\u001a\u000205J\u000e\u00106\u001a\u00020\f2\u0006\u00107\u001a\u00020'J\u0012\u00108\u001a\u00020\f2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030/J \u00109\u001a\u00020\f2\u0010\u0010\"\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0\u001f2\u0006\u0010:\u001a\u00020;J\u000e\u0010<\u001a\u00020\f2\u0006\u0010=\u001a\u00020%J\u000e\u0010>\u001a\u00020\f2\u0006\u0010?\u001a\u00020@J\u000e\u0010A\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020BJ\u000e\u0010C\u001a\u00020\f2\u0006\u0010D\u001a\u00020EJ\u0014\u0010F\u001a\u00020\f2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020H0\u001fJ\u001c\u0010I\u001a\u00020\f2\u0006\u0010J\u001a\u00020K2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020M0\u001fJ \u0010N\u001a\u00020\f\"\b\b\u0000\u0010O*\u00020P2\f\u0010Q\u001a\b\u0012\u0004\u0012\u0002HO0\u0013H\u0016J\u0014\u0010R\u001a\u00020\f2\n\u0010S\u001a\u0006\u0012\u0002\b\u00030/H\u0016J(\u0010S\u001a\u00020\f\"\b\b\u0000\u0010O*\u00020P2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010T\u001a\b\u0012\u0004\u0012\u0002HO0/H\u0016J\u0018\u0010=\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020%H\u0016J\u0010\u0010D\u001a\u00020\f2\u0006\u0010D\u001a\u00020EH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006U"}, d2={"Lio/koalaql/postgres/PostgresDialect$Compilation;", "Lio/koalaql/dialect/ExpressionCompiler;", "scope", "Lio/koalaql/sql/Scope;", "sql", "Lio/koalaql/sql/SqlTextBuilder;", "(Lio/koalaql/sql/Scope;Lio/koalaql/sql/SqlTextBuilder;)V", "getScope", "()Lio/koalaql/sql/Scope;", "getSql", "()Lio/koalaql/sql/SqlTextBuilder;", "aggregatable", "", "emitParens", "", "Lio/koalaql/expr/built/BuiltAggregatable;", "compileAggregatable", "compileCastDataType", "type", "Lio/koalaql/ddl/UnmappedDataType;", "compileDelete", "delete", "Lio/koalaql/query/built/BuiltDelete;", "compileExpr", "expr", "Lio/koalaql/expr/QuasiExpr;", "compileInsert", "insert", "Lio/koalaql/query/built/BuiltInsert;", "compileOrderBy", "ordinals", "", "Lio/koalaql/expr/Ordinal;", "compileQuery", "outerSelect", "Lio/koalaql/expr/SelectedExpr;", "query", "Lio/koalaql/query/built/BuiltSubquery;", "compileQueryWhere", "Lio/koalaql/query/built/BuiltQueryBody;", "compileRangeMarker", "direction", "", "marker", "Lio/koalaql/window/FrameRangeMarker;", "compileReference", "name", "Lio/koalaql/expr/Reference;", "compileRelation", "relation", "Lio/koalaql/query/built/BuiltRelation;", "compileSelect", "select", "Lio/koalaql/query/built/BuiltSelectQuery;", "compileSelectBody", "body", "compileSetLhs", "compileSetOperation", "operation", "Lio/koalaql/query/built/BuiltSetOperation;", "compileSubqueryExpr", "subquery", "compileUpdate", "update", "Lio/koalaql/query/built/BuiltUpdate;", "compileValues", "Lio/koalaql/query/built/BuiltValuesQuery;", "compileWindow", "window", "Lio/koalaql/window/built/BuiltWindow;", "compileWindows", "windows", "Lio/koalaql/window/LabeledWindow;", "compileWiths", "withType", "Lio/koalaql/query/WithType;", "withs", "Lio/koalaql/query/built/BuiltWith;", "dataTypeForCast", "T", "", "to", "excluded", "reference", "value", "postgres"})
    private static final class Compilation
    implements ExpressionCompiler {
        @NotNull
        private final Scope scope;
        @NotNull
        private final SqlTextBuilder sql;

        public Compilation(@NotNull Scope scope, @NotNull SqlTextBuilder sql) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            this.scope = scope;
            this.sql = sql;
        }

        public /* synthetic */ Compilation(Scope scope, SqlTextBuilder sqlTextBuilder, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                sqlTextBuilder = new SqlTextBuilder(IdentifierQuoteStyle.DOUBLE);
            }
            this(scope, sqlTextBuilder);
        }

        @NotNull
        public final Scope getScope() {
            return this.scope;
        }

        @NotNull
        public SqlTextBuilder getSql() {
            return this.sql;
        }

        public final void compileReference(@NotNull Reference<?> name) {
            Intrinsics.checkNotNullParameter(name, (String)"name");
            this.getSql().addResolved(this.scope.resolve(name));
        }

        public final void compileOrderBy(@NotNull List<? extends Ordinal<?>> ordinals) {
            Intrinsics.checkNotNullParameter(ordinals, (String)"ordinals");
            SqlTextBuildersKt.compileOrderBy((SqlTextBuilder)this.getSql(), ordinals, (Function1)new Function1<Expr<?>, Unit>(this){
                final /* synthetic */ Compilation this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Expr<?> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    this.this$0.compileExpr((QuasiExpr)it, false);
                }
            });
        }

        public final void compileAggregatable(@NotNull BuiltAggregatable aggregatable) {
            Intrinsics.checkNotNullParameter((Object)aggregatable, (String)"aggregatable");
            if (aggregatable.getDistinct() == Distinctness.DISTINCT) {
                this.getSql().addSql("DISTINCT ");
            }
            this.compileExpr((QuasiExpr)aggregatable.getExpr(), false);
            Collection collection = aggregatable.getOrderBy();
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.compileOrderBy(aggregatable.getOrderBy());
            }
        }

        public final void compileRangeMarker(@NotNull String direction, @NotNull FrameRangeMarker<?> marker) {
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Intrinsics.checkNotNullParameter(marker, (String)"marker");
            FrameRangeMarker<?> frameRangeMarker = marker;
            if (Intrinsics.areEqual(frameRangeMarker, (Object)CurrentRow.INSTANCE)) {
                this.getSql().addSql("CURRENT ROW");
            } else if (frameRangeMarker instanceof Following) {
                Compilation.compileExpr$default(this, (QuasiExpr)((Following)marker).getOffset(), false, 2, null);
            } else if (frameRangeMarker instanceof Preceding) {
                Compilation.compileExpr$default(this, (QuasiExpr)((Preceding)marker).getOffset(), false, 2, null);
            } else if (Intrinsics.areEqual(frameRangeMarker, (Object)Unbounded.INSTANCE)) {
                this.getSql().addSql(Intrinsics.stringPlus((String)"UNBOUNDED ", (Object)direction));
            }
        }

        public final void compileWindow(@NotNull BuiltWindow window) {
            boolean bl;
            boolean bl2;
            Intrinsics.checkNotNullParameter((Object)window, (String)"window");
            List partitionedBy = window.getPartitions().getPartitions();
            List orderBy = window.getPartitions().getOrderBy();
            SqlPrefix prefix = this.getSql().prefix("", " ");
            Object object = window.getPartitions().getFrom();
            if (object != null) {
                WindowLabel windowLabel = object;
                bl2 = false;
                bl = false;
                WindowLabel it = windowLabel;
                boolean bl3 = false;
                prefix.next((Function0)new Function0<Unit>(this, it){
                    final /* synthetic */ Compilation this$0;
                    final /* synthetic */ WindowLabel $it;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.getSql().addSql(this.this$0.getScope().nameOf(this.$it));
                    }
                });
            }
            object = partitionedBy;
            boolean bl4 = false;
            if (!object.isEmpty()) {
                prefix.next((Function0)new Function0<Unit>(this, partitionedBy){
                    final /* synthetic */ Compilation this$0;
                    final /* synthetic */ List<Expr<?>> $partitionedBy;
                    {
                        this.this$0 = $receiver;
                        this.$partitionedBy = $partitionedBy;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.getSql().prefix("PARTITION BY ", ", ").forEach((Iterable)this.$partitionedBy, (Function1)new Function1<Expr<?>, Unit>(this.this$0){
                            final /* synthetic */ Compilation this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Expr<?> it) {
                                Intrinsics.checkNotNullParameter(it, (String)"it");
                                this.this$0.compileExpr((QuasiExpr)it, false);
                            }
                        });
                    }
                });
            }
            object = orderBy;
            bl4 = false;
            if (!object.isEmpty()) {
                prefix.next((Function0)new Function0<Unit>(this, orderBy){
                    final /* synthetic */ Compilation this$0;
                    final /* synthetic */ List<Ordinal<?>> $orderBy;
                    {
                        this.this$0 = $receiver;
                        this.$orderBy = $orderBy;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.compileOrderBy(this.$orderBy);
                    }
                });
            }
            if ((object = window.getType()) != null) {
                Object object2 = object;
                bl2 = false;
                bl = false;
                Object windowType = object2;
                boolean bl5 = false;
                prefix.next((Function0)new Function0<Unit>(this, (FrameClauseType)windowType, window){
                    final /* synthetic */ Compilation this$0;
                    final /* synthetic */ FrameClauseType $windowType;
                    final /* synthetic */ BuiltWindow $window;
                    {
                        this.this$0 = $receiver;
                        this.$windowType = $windowType;
                        this.$window = $window;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.getSql().addSql(this.$windowType.getSql());
                        this.this$0.getSql().addSql(" ");
                        FrameRangeMarker until = this.$window.getUntil();
                        if (until == null) {
                            this.this$0.compileRangeMarker("PRECEDING", this.$window.getFrom());
                        } else {
                            this.this$0.getSql().addSql("BETWEEN ");
                            this.this$0.compileRangeMarker("PRECEDING", this.$window.getFrom());
                            this.this$0.getSql().addSql(" AND ");
                            this.this$0.compileRangeMarker("FOLLOWING", until);
                        }
                    }
                });
            }
        }

        public final void compileCastDataType(@NotNull UnmappedDataType<?> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            this.getSql().addSql(PostgresDialectKt.access$toRawSql(type));
        }

        public final boolean compileQuery(@NotNull List<? extends SelectedExpr<?>> outerSelect, @NotNull BuiltSubquery query) {
            Intrinsics.checkNotNullParameter(outerSelect, (String)"outerSelect");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Scope innerScope = this.scope.innerScope();
            query.populateScope(innerScope);
            SqlTextBuilder sqlTextBuilder = this.getSql();
            Compilation compilation = new Compilation(innerScope, sqlTextBuilder);
            sqlTextBuilder = query;
            if (sqlTextBuilder instanceof BuiltSelectQuery) {
                compilation.compileSelect(outerSelect, (BuiltSelectQuery)query);
                return true;
            }
            if (!(sqlTextBuilder instanceof BuiltValuesQuery)) {
                throw new NoWhenBranchMatchedException();
            }
            return compilation.compileValues((BuiltValuesQuery)query);
        }

        public final void compileSubqueryExpr(@NotNull BuiltSubquery subquery) {
            Intrinsics.checkNotNullParameter((Object)subquery, (String)"subquery");
            SqlTextBuilder.parenthesize$default((SqlTextBuilder)this.getSql(), (boolean)false, (Function0)((Function0)new Function0<Unit>(this, subquery){
                final /* synthetic */ Compilation this$0;
                final /* synthetic */ BuiltSubquery $subquery;
                {
                    this.this$0 = $receiver;
                    this.$subquery = $subquery;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.compileQuery(CollectionsKt.emptyList(), this.$subquery);
                }
            }), (int)1, null);
        }

        public final void compileSetLhs(@NotNull Reference<?> expr) {
            Intrinsics.checkNotNullParameter(expr, (String)"expr");
            this.getSql().addIdentifier(this.scope.resolve(expr).getInnerName());
        }

        public final void compileExpr(@NotNull QuasiExpr expr, boolean emitParens) {
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            SqlTextBuildersKt.compileExpr((SqlTextBuilder)this.getSql(), (QuasiExpr)expr, (boolean)emitParens, (ExpressionCompiler)this);
        }

        public static /* synthetic */ void compileExpr$default(Compilation compilation, QuasiExpr quasiExpr, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            compilation.compileExpr(quasiExpr, bl);
        }

        public final void compileRelation(@NotNull BuiltRelation relation) {
            List list;
            Intrinsics.checkNotNullParameter((Object)relation, (String)"relation");
            Relation baseRelation = relation.getRelation();
            if (baseRelation instanceof TableRelation) {
                this.getSql().addIdentifier(((TableRelation)baseRelation).getTableName());
                list = null;
            } else if (baseRelation instanceof Subquery) {
                Scope innerScope = this.scope.innerScope();
                ((Subquery)baseRelation).getOf().populateScope(innerScope);
                SqlTextBuilder.parenthesize$default((SqlTextBuilder)this.getSql(), (boolean)false, (Function0)((Function0)new Function0<Unit>(innerScope, this, baseRelation){
                    final /* synthetic */ Scope $innerScope;
                    final /* synthetic */ Compilation this$0;
                    final /* synthetic */ Relation $baseRelation;
                    {
                        this.$innerScope = $innerScope;
                        this.this$0 = $receiver;
                        this.$baseRelation = $baseRelation;
                        super(0);
                    }

                    public final void invoke() {
                        new Compilation(this.$innerScope, this.this$0.getSql()).compileQuery(CollectionsKt.emptyList(), ((Subquery)this.$baseRelation).getOf());
                    }
                }), (int)1, null);
                list = ((Subquery)baseRelation).getOf() instanceof BuiltValuesQuery ? ((Subquery)baseRelation).getOf().getColumns() : (List)null;
            } else if (baseRelation instanceof Values) {
                SqlTextBuilder.parenthesize$default((SqlTextBuilder)this.getSql(), (boolean)false, (Function0)((Function0)new Function0<Unit>(this, baseRelation){
                    final /* synthetic */ Compilation this$0;
                    final /* synthetic */ Relation $baseRelation;
                    {
                        this.this$0 = $receiver;
                        this.$baseRelation = $baseRelation;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.compileValues(new BuiltValuesQuery((Values)this.$baseRelation));
                    }
                }), (int)1, null);
                list = (List)((Values)baseRelation).getColumns();
            } else if (baseRelation instanceof Cte) {
                this.getSql().addSql(this.scope.get((Cte)baseRelation));
                if (Intrinsics.areEqual((Object)relation.getComputedAlias().getIdentifier(), (Object)((Cte)baseRelation).getIdentifier())) {
                    return;
                }
                list = null;
            } else {
                if (baseRelation instanceof EmptyRelation) {
                    return;
                }
                throw new NoWhenBranchMatchedException();
            }
            List explicitLabels2 = list;
            this.getSql().addSql(" ");
            this.getSql().addSql(this.scope.get(relation.getComputedAlias()));
            List list2 = explicitLabels2;
            if (list2 != null) {
                List list3 = list2;
                boolean bl = false;
                boolean bl2 = false;
                List labels = list3;
                boolean bl3 = false;
                SqlTextBuilder.parenthesize$default((SqlTextBuilder)this.getSql(), (boolean)false, (Function0)((Function0)new Function0<Unit>(this, labels){
                    final /* synthetic */ Compilation this$0;
                    final /* synthetic */ List<Reference<?>> $labels;
                    {
                        this.this$0 = $receiver;
                        this.$labels = $labels;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.getSql().prefix("", ", ").forEach((Iterable)this.$labels, (Function1)new Function1<Reference<?>, Unit>(this.this$0){
                            final /* synthetic */ Compilation this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Reference<?> it) {
                                Intrinsics.checkNotNullParameter(it, (String)"it");
                                this.this$0.getSql().addSql(this.this$0.getScope().nameOf(it));
                            }
                        });
                    }
                }), (int)1, null);
            }
        }

        public final void compileQueryWhere(@NotNull BuiltQueryBody query) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            this.compileRelation(query.getRelation());
            Iterable $this$forEach$iv = CollectionsKt.asReversedMutable((List)query.getJoins());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BuiltJoin join = (BuiltJoin)element$iv;
                boolean bl = false;
                this.getSql().addSql("\n");
                this.getSql().addSql(join.getType().getSql());
                this.getSql().addSql(" ");
                this.compileRelation(join.getTo());
                this.getSql().addSql(" ON ");
                this.compileExpr((QuasiExpr)join.getOn(), false);
            }
            Expr expr = query.getWhere();
            if (expr != null) {
                Expr expr2 = expr;
                boolean bl = false;
                boolean bl2 = false;
                Expr it = expr2;
                boolean bl3 = false;
                this.getSql().addSql("\nWHERE ");
                this.compileExpr((QuasiExpr)it, false);
            }
        }

        public final void compileSelectBody(@NotNull BuiltQueryBody body) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            this.compileQueryWhere(body);
            this.getSql().prefix("\nGROUP BY ", ", ").forEach((Iterable)body.getGroupBy(), new Function1<Expr<?>, Unit>(this){
                final /* synthetic */ Compilation this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Expr<?> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    this.this$0.compileExpr((QuasiExpr)it, false);
                }
            });
            Expr expr = body.getHaving();
            if (expr != null) {
                Expr expr2 = expr;
                boolean bl = false;
                boolean bl2 = false;
                Expr it = expr2;
                boolean bl3 = false;
                this.getSql().addSql("\nHAVING ");
                this.compileExpr((QuasiExpr)it, false);
            }
            this.getSql().prefix("\nWINDOW ", "\n, ").forEach((Iterable)body.getWindows(), (Function1)new Function1<LabeledWindow, Unit>(this){
                final /* synthetic */ Compilation this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull LabeledWindow it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.this$0.getSql().addSql(this.this$0.getScope().nameOf(it.getLabel()));
                    this.this$0.getSql().addSql(" AS ");
                    this.this$0.getSql().addSql("(");
                    this.this$0.compileWindow(BuiltWindow.Companion.from((WindowBuilder)it.getWindow()));
                    this.this$0.getSql().addSql(")");
                }
            });
        }

        public final void compileSetOperation(@NotNull List<? extends SelectedExpr<?>> outerSelect, @NotNull BuiltSetOperation operation) {
            Intrinsics.checkNotNullParameter(outerSelect, (String)"outerSelect");
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            this.getSql().addSql("\n");
            this.getSql().addSql(operation.getType().getSql());
            if (operation.getDistinctness() == Distinctness.ALL) {
                this.getSql().addSql(" ALL");
            }
            this.getSql().addSql("\n");
            BuiltSelectQuery selectQuery = operation.getBody().toSelectQuery(outerSelect);
            Scope scope = this.scope.innerScope();
            boolean bl = false;
            boolean bl2 = false;
            Scope it = scope;
            boolean bl3 = false;
            selectQuery.populateScope(it);
            Unit unit = Unit.INSTANCE;
            SqlTextBuilder sqlTextBuilder = this.getSql();
            Scope scope2 = scope;
            new Compilation(scope2, sqlTextBuilder).compileSelect(outerSelect, selectQuery);
        }

        public final void compileWiths(@NotNull WithType withType, @NotNull List<BuiltWith> withs) {
            String string;
            Intrinsics.checkNotNullParameter((Object)withType, (String)"withType");
            Intrinsics.checkNotNullParameter(withs, (String)"withs");
            SqlTextBuilder sqlTextBuilder = this.getSql();
            WithType withType2 = withType;
            int n = WhenMappings.$EnumSwitchMapping$0[withType2.ordinal()];
            switch (n) {
                case 1: {
                    string = "WITH RECURSIVE ";
                    break;
                }
                case 2: {
                    string = "WITH ";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            sqlTextBuilder.prefix(string, "\n, ").forEach((Iterable)withs, (Function1)new Function1<BuiltWith, Unit>(this){
                final /* synthetic */ Compilation this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull BuiltWith it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Scope innerScope = this.this$0.getScope().innerScope();
                    it.getQuery().populateScope(innerScope);
                    this.this$0.getSql().addSql(this.this$0.getScope().get(it.getCte()));
                    this.this$0.getSql().addSql(" AS (");
                    new Compilation(innerScope, this.this$0.getSql()).compileQuery(CollectionsKt.emptyList(), it.getQuery());
                    this.this$0.getSql().addSql(")");
                }
            });
        }

        public final void compileSelect(@NotNull List<? extends SelectedExpr<?>> outerSelect, @NotNull BuiltSelectQuery select) {
            Object $this$forEach$iv;
            Intrinsics.checkNotNullParameter(outerSelect, (String)"outerSelect");
            Intrinsics.checkNotNullParameter((Object)select, (String)"select");
            List withs = select.getBody().getWiths();
            this.compileWiths(select.getBody().getWithType(), withs);
            Collection collection = withs;
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.getSql().addSql("\n");
            }
            SqlPrefix selectPrefix = this.getSql().prefix("SELECT ", "\n, ");
            List list = select.getSelected();
            boolean bl2 = false;
            boolean bl3 = false;
            List it = list;
            boolean bl4 = false;
            Collection collection2 = it;
            int n = 0;
            Iterable iterable = !collection2.isEmpty() ? list : null;
            iterable = iterable == null ? outerSelect : iterable;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                it = (SelectedExpr)element$iv;
                boolean bl5 = false;
                selectPrefix.next((Function0)new Function0<Unit>(this, it){
                    final /* synthetic */ Compilation this$0;
                    final /* synthetic */ SelectedExpr<?> $it;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.compileExpr((QuasiExpr)this.$it.getExpr(), false);
                        this.this$0.getSql().addSql(" ");
                        this.this$0.getSql().addIdentifier(this.this$0.getScope().nameOf(this.$it.getName()));
                    }
                });
            }
            if (!Intrinsics.areEqual((Object)select.getBody().getRelation().getRelation(), (Object)EmptyRelation.INSTANCE)) {
                this.getSql().addSql("\nFROM ");
            }
            this.compileSelectBody(select.getBody());
            $this$forEach$iv = select.getBody().getSetOperations();
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                it = (BuiltSetOperation)element$iv;
                boolean bl6 = false;
                this.compileSetOperation(select.getSelected(), (BuiltSetOperation)it);
            }
            $this$forEach$iv = select.getBody().getOrderBy();
            $i$f$forEach = false;
            if (!$this$forEach$iv.isEmpty()) {
                this.getSql().addSql("\n");
            }
            this.compileOrderBy(select.getBody().getOrderBy());
            $this$forEach$iv = select.getBody().getLimit();
            if ($this$forEach$iv != null) {
                Object $i$f$forEach2 = $this$forEach$iv;
                boolean bl7 = false;
                boolean element$iv = false;
                int it2 = ((Number)$i$f$forEach2).intValue();
                boolean bl8 = false;
                this.getSql().addSql("\nLIMIT ");
                Integer value$iv = it2;
                boolean $i$f$value = false;
                this.getSql().addLiteral(new Literal(Reflection.getOrCreateKotlinClass(Integer.class), (Object)value$iv));
            }
            if (select.getBody().getOffset() != 0) {
                boolean $this$forEach$iv2 = select.getBody().getLimit() != null;
                boolean $i$f$forEach2 = false;
                boolean bl9 = false;
                if (!$this$forEach$iv2) {
                    boolean bl10 = false;
                    String string = "MySQL does not support OFFSET without LIMIT";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                this.getSql().addSql(" OFFSET ");
                Integer value$iv = select.getBody().getOffset();
                boolean $i$f$value = false;
                this.getSql().addLiteral(new Literal(Reflection.getOrCreateKotlinClass(Integer.class), (Object)value$iv));
            }
            if ((iterable = select.getBody().getLocking()) != null) {
                Iterable iterable2 = iterable;
                boolean bl11 = false;
                bl3 = false;
                Iterable locking = iterable2;
                boolean bl12 = false;
                collection2 = locking;
                n = WhenMappings.$EnumSwitchMapping$1[collection2.ordinal()];
                switch (n) {
                    case 1: {
                        this.getSql().addSql("\nFOR SHARE");
                        break;
                    }
                    case 2: {
                        this.getSql().addSql("\nFOR UPDATE");
                    }
                }
            }
        }

        public final boolean compileValues(@NotNull BuiltValuesQuery query) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            return SqlTextBuildersKt.compileValues$default((SqlTextBuilder)this.getSql(), (BuiltValuesQuery)query, (Function1)new Function1<Expr<?>, Unit>(this){
                final /* synthetic */ Compilation this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Expr<?> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    this.this$0.compileExpr((QuasiExpr)it, false);
                }
            }, null, (int)4, null);
        }

        public final boolean compileInsert(@NotNull BuiltInsert insert) {
            Intrinsics.checkNotNullParameter((Object)insert, (String)"insert");
            TableRelation relvar = insert.unwrapTable();
            this.compileWiths(insert.getWithType(), insert.getWiths());
            Collection collection = insert.getWiths();
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.getSql().addSql("\n");
            }
            SqlTextBuildersKt.compileInsertLine$default((SqlTextBuilder)this.getSql(), (BuiltInsert)insert, null, (Function0)((Function0)new Function0<Unit>(this, relvar, insert){
                final /* synthetic */ Compilation this$0;
                final /* synthetic */ TableRelation $relvar;
                final /* synthetic */ BuiltInsert $insert;
                {
                    this.this$0 = $receiver;
                    this.$relvar = $relvar;
                    this.$insert = $insert;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.getSql().addIdentifier(this.$relvar.getTableName());
                    this.this$0.getSql().addSql(" AS ");
                    this.this$0.getSql().addSql(this.this$0.getScope().get(this.$insert.getRelation().getComputedAlias()));
                }
            }), (int)2, null);
            this.getSql().addSql("\n");
            boolean nonEmpty = this.compileQuery(CollectionsKt.emptyList(), insert.getQuery());
            SqlTextBuildersKt.compileOnConflict((SqlTextBuilder)this.getSql(), (OnConflictOrDuplicateAction)insert.getOnConflict(), (Function1)new Function1<List<? extends Assignment<?>>, Unit>(this, relvar, insert){
                final /* synthetic */ Compilation this$0;
                final /* synthetic */ TableRelation $relvar;
                final /* synthetic */ BuiltInsert $insert;
                {
                    this.this$0 = $receiver;
                    this.$relvar = $relvar;
                    this.$insert = $insert;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull List<? extends Assignment<?>> assignments) {
                    void $this$forEach$iv;
                    Intrinsics.checkNotNullParameter(assignments, (String)"assignments");
                    Scope innerScope = this.this$0.getScope().innerScope();
                    Iterable iterable = this.$relvar.getColumns();
                    BuiltInsert builtInsert = this.$insert;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Column it = (Column)element$iv;
                        boolean bl = false;
                        innerScope.internal((Reference)it, it.getSymbol(), builtInsert.getRelation().getComputedAlias());
                    }
                    Compilation updateCtx = new Compilation(innerScope, this.this$0.getSql());
                    this.this$0.getSql().prefix(" ", "\n,").forEach((Iterable)assignments, (Function1)new Function1<Assignment<?>, Unit>(this.this$0, updateCtx){
                        final /* synthetic */ Compilation this$0;
                        final /* synthetic */ Compilation $updateCtx;
                        {
                            this.this$0 = $receiver;
                            this.$updateCtx = $updateCtx;
                            super(1);
                        }

                        public final void invoke(@NotNull Assignment<?> it) {
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            this.this$0.getSql().addIdentifier(it.getReference().getSymbol());
                            this.this$0.getSql().addSql(" = ");
                            Compilation.compileExpr$default(this.$updateCtx, (QuasiExpr)it.getExpr(), false, 2, null);
                        }
                    });
                }
            });
            return nonEmpty;
        }

        /*
         * WARNING - void declaration
         */
        public final void compileUpdate(@NotNull BuiltUpdate update) {
            Object it;
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)update, (String)"update");
            BuiltQueryBody query = update.getQuery();
            this.compileWiths(query.getWithType(), query.getWiths());
            Collection collection = query.getWiths();
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.getSql().addSql("\n");
            }
            this.getSql().addSql("UPDATE ");
            this.compileRelation(update.getQuery().getRelation());
            this.getSql().addSql("\nSET ");
            SqlPrefix updatePrefix = this.getSql().prefix("", ", ");
            bl = query.getJoins().isEmpty();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "JOIN in update not supported";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Iterable iterable = update.getAssignments();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Assignment)element$iv;
                boolean bl5 = false;
                updatePrefix.next((Function0)new Function0<Unit>(this, it){
                    final /* synthetic */ Compilation this$0;
                    final /* synthetic */ Assignment<?> $it;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.compileSetLhs((Reference)this.$it.getReference());
                        this.this$0.getSql().addSql(" = ");
                        Compilation.compileExpr$default(this.this$0, (QuasiExpr)this.$it.getExpr(), false, 2, null);
                    }
                });
            }
            iterable = query.getWhere();
            if (iterable != null) {
                Iterable iterable2 = iterable;
                boolean bl6 = false;
                boolean bl7 = false;
                it = iterable2;
                boolean bl8 = false;
                this.getSql().addSql("\nWHERE ");
                this.compileExpr((QuasiExpr)it, false);
            }
        }

        public void excluded(@NotNull Reference<?> reference) {
            Intrinsics.checkNotNullParameter(reference, (String)"reference");
            this.getSql().addSql("EXCLUDED.");
            Reference<?> reference2 = reference;
            if (reference2 instanceof Column) {
                this.getSql().addIdentifier(((Column)reference).getSymbol());
            } else {
                this.compileReference(reference);
            }
        }

        public <T> void reference(boolean emitParens, @NotNull Reference<T> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            this.compileReference(value);
        }

        public void subquery(boolean emitParens, @NotNull BuiltSubquery subquery) {
            Intrinsics.checkNotNullParameter((Object)subquery, (String)"subquery");
            this.compileSubqueryExpr(subquery);
        }

        public void aggregatable(boolean emitParens, @NotNull BuiltAggregatable aggregatable) {
            Intrinsics.checkNotNullParameter((Object)aggregatable, (String)"aggregatable");
            this.compileAggregatable(aggregatable);
        }

        public <T> void dataTypeForCast(@NotNull UnmappedDataType<T> to) {
            Intrinsics.checkNotNullParameter(to, (String)"to");
            this.compileCastDataType(to);
        }

        public void window(@NotNull BuiltWindow window) {
            Intrinsics.checkNotNullParameter((Object)window, (String)"window");
            this.compileWindow(window);
        }

        public final void compileWindows(@NotNull List<LabeledWindow> windows) {
            Intrinsics.checkNotNullParameter(windows, (String)"windows");
            this.getSql().prefix("\nWINDOW ", "\n, ").forEach((Iterable)windows, (Function1)new Function1<LabeledWindow, Unit>(this){
                final /* synthetic */ Compilation this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull LabeledWindow it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.this$0.getSql().addSql(this.this$0.getScope().nameOf(it.getLabel()));
                    this.this$0.getSql().addSql(" AS ");
                    this.this$0.getSql().addSql("(");
                    this.this$0.compileWindow(BuiltWindow.Companion.from((WindowBuilder)it.getWindow()));
                    this.this$0.getSql().addSql(")");
                }
            });
        }

        public final void compileDelete(@NotNull BuiltDelete delete) {
            Intrinsics.checkNotNullParameter((Object)delete, (String)"delete");
            List withs = delete.getQuery().getWiths();
            this.compileWiths(delete.getQuery().getWithType(), withs);
            Collection collection = withs;
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.getSql().addSql("\n");
            }
            this.getSql().addSql("\nDELETE FROM ");
            SqlTextBuildersKt.compileQueryBody$default((SqlTextBuilder)this.getSql(), (BuiltQueryBody)delete.getQuery(), (Function1)new Function1<Expr<?>, Unit>(this){
                final /* synthetic */ Compilation this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Expr<?> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    this.this$0.compileExpr((QuasiExpr)it, false);
                }
            }, (Function1)((Function1)new Function1<BuiltRelation, Unit>(this){
                final /* synthetic */ Compilation this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull BuiltRelation it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.this$0.compileRelation(it);
                }
            }), (Function1)((Function1)new Function1<List<? extends LabeledWindow>, Unit>(this){
                final /* synthetic */ Compilation this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull List<LabeledWindow> windows) {
                    Intrinsics.checkNotNullParameter(windows, (String)"windows");
                    this.this$0.compileWindows(windows);
                }
            }), null, null, null, null, (int)240, null);
            boolean bl2 = delete.getQuery().getSetOperations().isEmpty();
            bl = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl2) {
                boolean bl5 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Object object = delete.getQuery().getOrderBy();
            bl = false;
            if (!object.isEmpty()) {
                this.getSql().addSql("\n");
            }
            this.compileOrderBy(delete.getQuery().getOrderBy());
            object = delete.getQuery().getLimit();
            if (object != null) {
                Object object2 = object;
                bl3 = false;
                bl4 = false;
                int it = ((Number)object2).intValue();
                boolean bl6 = false;
                this.getSql().addSql("\nLIMIT ");
                Integer value$iv = it;
                boolean $i$f$value = false;
                this.getSql().addLiteral(new Literal(Reflection.getOrCreateKotlinClass(Integer.class), (Object)value$iv));
            }
            if (delete.getQuery().getOffset() != 0) {
                boolean bl7 = delete.getQuery().getLimit() != null;
                boolean bl8 = false;
                bl3 = false;
                if (!bl7) {
                    boolean bl9 = false;
                    String string = "MySQL does not support OFFSET without LIMIT";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                this.getSql().addSql(" OFFSET ");
                Integer value$iv = delete.getQuery().getOffset();
                boolean $i$f$value = false;
                this.getSql().addLiteral(new Literal(Reflection.getOrCreateKotlinClass(Integer.class), (Object)value$iv));
            }
            boolean bl10 = delete.getQuery().getLocking() == null;
            boolean bl11 = false;
            bl3 = false;
            bl3 = false;
            bl4 = false;
            if (!bl10) {
                boolean bl12 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[WithType.values().length];
                nArray[WithType.RECURSIVE.ordinal()] = 1;
                nArray[WithType.NOT_RECURSIVE.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[LockMode.values().length];
                nArray[LockMode.SHARE.ordinal()] = 1;
                nArray[LockMode.UPDATE.ordinal()] = 2;
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IndexType.values().length];
            nArray[IndexType.PRIMARY.ordinal()] = 1;
            nArray[IndexType.UNIQUE.ordinal()] = 2;
            nArray[IndexType.INDEX.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

