/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.console.installer;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.oomph.console.core.parameters.Parameters;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.log.ProgressLog;

public class ConsoleProgressLog
implements ProgressLog {
    private boolean verbose = Parameters.VERBOSE;

    public ConsoleProgressLog() {
    }

    public ConsoleProgressLog(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isCanceled() {
        return false;
    }

    public void log(String line) {
        if (this.verbose && !line.isEmpty()) {
            System.out.println(line);
        }
    }

    public void log(String line, ProgressLog.Severity severity) {
        if (severity != ProgressLog.Severity.ERROR) {
            this.log(line);
        } else {
            this.log(line);
        }
    }

    public void log(String line, boolean filter) {
        if (!filter || this.verbose) {
            this.log(line);
        }
    }

    public void log(String line, boolean filter, ProgressLog.Severity severity) {
        if (!filter || this.verbose) {
            this.log(line, severity);
        }
    }

    public void log(IStatus status) {
    }

    public void log(Throwable t) {
        this.log(t.getMessage());
    }

    public void task(SetupTask setupTask) {
        String description = setupTask.getDescription();
        if (description != null && !description.isEmpty()) {
            this.log(description);
        }
    }

    public void setTerminating() {
    }
}

