/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.console.test;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.nio.file.Paths;
import java.security.KeyStore;
import org.eclipse.oomph.console.application.ConsoleLauncherApplication;
import org.eclipse.oomph.console.core.parameters.Parameters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import sun.misc.Unsafe;

public class InstallerTest
extends ConsoleLauncherApplication {
    private static final String PROJECT_BASEDIR = System.getProperty("project.basedir", Paths.get("", new String[0]).toFile().getAbsolutePath());
    private static final String PROJECT_BUILD_DIR = System.getProperty("project.build.directory", PROJECT_BASEDIR + "/target");
    private static final String PROJECT_PARENT_BASEDIR = System.getProperty("project.parent.basedir", Paths.get(PROJECT_BASEDIR, new String[0]).toFile().getParent());
    private static final String SETUPS_DIR = PROJECT_PARENT_BASEDIR + "/org.eclipse.oomph.console.product/setups/";
    private static final String REDIRECTION_KEY = "oomph.redirection.setupsDir";
    private static final String REDIRECTION_VALUE = "index:/->" + SETUPS_DIR;

    public static KeyStore createKeyStore(String jksPath, String password) throws Exception {
        File file = new File(jksPath);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        if (!file.exists()) {
            keyStore.load(null, null);
            keyStore.store(new FileOutputStream(file), password.toCharArray());
        }
        return keyStore;
    }

    protected static void setFinalParameter(String fieldName, Object value) throws Exception {
        Field field = Parameters.class.getDeclaredField(fieldName);
        field.setAccessible(true);
        Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
        unsafeField.setAccessible(true);
        Unsafe unsafe = (Unsafe)unsafeField.get(null);
        Object fieldBase = unsafe.staticFieldBase(field);
        long fieldOffset = unsafe.staticFieldOffset(field);
        unsafe.putObject(fieldBase, fieldOffset, value);
    }

    private void setRedirectionDir(String lacation) throws Exception {
        System.setProperty(REDIRECTION_KEY, lacation);
    }

    private void setLocation(String lacation) throws Exception {
        System.setProperty("user.home", lacation);
        System.setProperty("user.dir", lacation);
        System.setProperty("oomph.installation.location", lacation);
        InstallerTest.setFinalParameter("INSTALLATION_LOCATION", lacation);
        System.setProperty("oomph.workspace.location", lacation);
        InstallerTest.setFinalParameter("WORKSPACE_LOCATION", lacation);
    }

    private void setConfiguration(String lacation) throws Exception {
        System.setProperty("oomph.configuration.setups", lacation);
        InstallerTest.setFinalParameter("CONFIGURATION", lacation);
        System.clearProperty("oomph.product.id");
        InstallerTest.setFinalParameter("PRODUCT", "");
        System.clearProperty("oomph.project.id");
        InstallerTest.setFinalParameter("PROJECT", "");
        System.clearProperty(REDIRECTION_KEY);
    }

    private void setProduct(String product) throws Exception {
        System.clearProperty("oomph.configuration.setups");
        InstallerTest.setFinalParameter("CONFIGURATION", null);
        System.setProperty("oomph.product.id", product);
        InstallerTest.setFinalParameter("PRODUCT", product);
    }

    private void setProject(String project) throws Exception {
        InstallerTest.setFinalParameter("PROJECT", project);
        System.setProperty("oomph.project.id", project);
    }

    @Before
    public void setUp() throws Exception {
        String jksPath = PROJECT_BUILD_DIR + "/empty.jks";
        String jksPass = "changeit";
        InstallerTest.createKeyStore(jksPath, jksPass);
        System.setProperty("javax.net.ssl.trustStore", jksPath);
        System.setProperty("javax.net.ssl.trustStorePassword", jksPass);
        System.setProperty("oomph.installer.ssl.insecure", "true");
        System.setProperty("oomph.installer.verbose", System.getProperty("oomph.installer.verbose", "false"));
        System.setProperty("oomph.setup.ecf.trace", System.getProperty("oomph.setup.ecf.trace", "false"));
        System.setProperty("oomph.setup.user.home.redirect", "true");
        System.out.println();
    }

    @Test
    public void installEclipseApp() throws Exception {
        this.setLocation(PROJECT_BUILD_DIR + "/ide");
        this.setRedirectionDir(REDIRECTION_VALUE);
        this.setProduct("epp.package.java_custom");
        this.setProject("bash.editor,oomph.console");
        Assert.assertNull((Object)this.start(null));
    }

    @Test
    public void installEclipseConfigurationFromFile() throws Exception {
        this.setLocation(PROJECT_BUILD_DIR + "/ide_conf_file");
        this.setConfiguration(SETUPS_DIR + "/Configuration.setup");
        this.setRedirectionDir(REDIRECTION_VALUE);
        this.setProject("bash.editor,oomph.console");
        Assert.assertNull((Object)this.start(null));
    }

    @Test
    public void installEclipseConfigurationFromURL() throws Exception {
        this.setLocation(PROJECT_BUILD_DIR + "/ide_conf_http");
        String url = "https://raw.githubusercontent.com/eclipse/birt/master/build/org.eclipse.birt.releng/BIRTConfiguration.setup";
        this.setConfiguration(url);
        Assert.assertNull((Object)this.start(null));
    }
}

