/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.console.installer;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.oomph.console.core.parameters.Parameters;

public class ConsoleProgressMonitor
implements IProgressMonitor {
    private double totalWork = 0.0;
    private double worked = 0.0;
    private boolean headerPrinted = false;
    private String headerText = null;
    private boolean verbose = Parameters.VERBOSE;
    private boolean textLayout = Parameters.TEXT_LAYOUT;
    private long oldTime = 0L;

    public ConsoleProgressMonitor() {
    }

    public ConsoleProgressMonitor(boolean verbose, String headerText) {
        this.verbose = verbose;
        this.headerText = headerText;
    }

    public void beginTask(String name, int totalWork) {
        this.totalWork = totalWork;
    }

    public void done() {
        this.internalWorked(this.totalWork - this.worked);
        this.printLine("");
    }

    public void internalWorked(double work) {
        int length = 70;
        long newTime = System.currentTimeMillis();
        if (!this.headerPrinted) {
            this.printHeader();
            this.headerPrinted = true;
        }
        if (!this.verbose && !this.textLayout) {
            this.worked += work;
            int percentageWorked = (int)(this.worked / this.totalWork * 100.0);
            double workDecimal = this.worked / this.totalWork;
            if (newTime - this.oldTime > 100L || this.worked >= 100.0) {
                this.returnToStart();
                this.print("[");
                int i = 0;
                while ((double)i <= workDecimal * (double)length) {
                    this.print("#");
                    ++i;
                }
                i = (int)(workDecimal * (double)length);
                while (i < length) {
                    this.print(".");
                    ++i;
                }
                this.print("]");
                this.print(percentageWorked + "%");
                this.oldTime = System.currentTimeMillis();
            }
        }
    }

    private void printHeader() {
        if (this.headerText != null && !this.textLayout) {
            System.out.println(this.headerText);
        }
    }

    public boolean isCanceled() {
        return false;
    }

    public void setCanceled(boolean value) {
        this.printLine("Cancelled!");
    }

    public void setTaskName(String name) {
        if (this.verbose) {
            this.printLine(name);
        }
    }

    public void subTask(String name) {
        if (this.verbose) {
            this.printLine(name);
        }
    }

    public void worked(int work) {
    }

    private void returnToStart() {
        this.print("\r");
    }

    private void print(String input) {
        System.out.print(input);
    }

    private void printLine(String line) {
        System.out.println(line);
    }
}

