/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.console.core.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.oomph.setup.Index;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.util.CatalogManager;
import org.eclipse.oomph.setup.internal.core.util.ECFURIHandlerImpl;
import org.eclipse.oomph.setup.internal.core.util.ResourceMirror;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.util.CollectionUtil;

public class InstallationInitializer {
    private final CatalogManager catalogManager = new CatalogManager();
    private ResourceSet resourceSet = SetupCoreUtil.createResourceSet();

    public InstallationInitializer() {
        this.resourceSet.getLoadOptions().put("OPTION_CACHE_HANDLING", ECFURIHandlerImpl.CacheHandling.CACHE_WITH_ETAG_CHECKING);
        this.loadResourceSet(SetupContext.INDEX_SETUP_URI, SetupContext.USER_SETUP_URI);
        this.loadIndex((IProgressMonitor)new NullProgressMonitor());
    }

    private void loadResourceSet(final URI ... uris) {
        ResourceMirror resourceMirror = new ResourceMirror(this.resourceSet){

            protected void run(String taskName, IProgressMonitor monitor) {
                this.perform(uris);
            }
        };
        resourceMirror.begin((IProgressMonitor)new NullProgressMonitor());
    }

    public void loadIndex(IProgressMonitor progressMonitor) {
        LinkedHashMap uriMap = new LinkedHashMap();
        final LinkedHashMap<URI, Resource> resourceMap = new LinkedHashMap<URI, Resource>();
        URIConverter uriConverter = this.resourceSet.getURIConverter();
        for (Resource resource : this.resourceSet.getResources()) {
            EList contents = resource.getContents();
            if (contents.isEmpty()) continue;
            EClass eClass = ((EObject)contents.get(0)).eClass();
            URI uri = uriConverter.normalize(resource.getURI());
            String scheme = uri.scheme();
            if (!"http".equals(scheme) && !"https".equals(scheme)) continue;
            CollectionUtil.add(uriMap, (Object)eClass, (Object)uri);
            resourceMap.put(uri, resource);
        }
        LinkedHashSet resourceURIs = new LinkedHashSet();
        EClass[] eClassArray = new EClass[]{SetupPackage.Literals.INDEX, SetupPackage.Literals.PRODUCT_CATALOG, SetupPackage.Literals.PRODUCT, SetupPackage.Literals.PROJECT_CATALOG, SetupPackage.Literals.PROJECT};
        int n = eClassArray.length;
        int contents = 0;
        while (contents < n) {
            EClass eClass = eClassArray[contents];
            Set uris = (Set)uriMap.remove(eClass);
            if (uris != null) {
                resourceURIs.addAll(uris);
            }
            ++contents;
        }
        for (Set uris : uriMap.values()) {
            resourceURIs.addAll(uris);
        }
        final HashSet updatedResources = new HashSet();
        if (!resourceURIs.isEmpty()) {
            new ECFURIHandlerImpl.ETagMirror(){

                protected synchronized void cacheUpdated(URI uri) {
                    updatedResources.add((Resource)resourceMap.get(uri));
                }
            }.begin(resourceURIs, progressMonitor);
        }
        Resource resource = this.resourceSet.getResource(SetupContext.INDEX_SETUP_URI, false);
        this.catalogManager.indexLoaded((Index)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)SetupPackage.Literals.INDEX));
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }
}

