/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.junit;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.oomph.junit.JUnitDocumentRoot;
import org.eclipse.oomph.junit.JUnitPackage;
import org.eclipse.oomph.junit.ProblemType;
import org.eclipse.oomph.junit.PropertiesType;
import org.eclipse.oomph.junit.PropertyType;
import org.eclipse.oomph.junit.TestCaseType;
import org.eclipse.oomph.junit.TestSuite;
import org.eclipse.oomph.junit.TestSuiteType;
import org.eclipse.oomph.junit.TestSuitesType;

public class JUnitFactory
extends EFactoryImpl {
    public static final JUnitFactory eINSTANCE = JUnitFactory.init();

    public static JUnitFactory init() {
        try {
            JUnitFactory theJUnitFactory = (JUnitFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/oomph/junit/1.0");
            if (theJUnitFactory != null) {
                return theJUnitFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new JUnitFactory();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createJUnitDocumentRoot();
            }
            case 1: {
                return this.createTestSuitesType();
            }
            case 2: {
                return this.createTestSuite();
            }
            case 3: {
                return this.createTestSuiteType();
            }
            case 4: {
                return this.createTestCaseType();
            }
            case 5: {
                return this.createProblemType();
            }
            case 6: {
                return this.createPropertiesType();
            }
            case 7: {
                return this.createPropertyType();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.createISO8601DateTimeFromString(eDataType, initialValue);
            }
            case 9: {
                return this.createNameTypeFromString(eDataType, initialValue);
            }
            case 10: {
                return this.createTimeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.convertISO8601DateTimeToString(eDataType, instanceValue);
            }
            case 9: {
                return this.convertNameTypeToString(eDataType, instanceValue);
            }
            case 10: {
                return this.convertTimeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public JUnitDocumentRoot createJUnitDocumentRoot() {
        JUnitDocumentRoot jUnitDocumentRoot = new JUnitDocumentRoot();
        return jUnitDocumentRoot;
    }

    public TestSuitesType createTestSuitesType() {
        TestSuitesType testSuitesType = new TestSuitesType();
        return testSuitesType;
    }

    public TestSuite createTestSuite() {
        TestSuite testSuite = new TestSuite();
        return testSuite;
    }

    public TestSuiteType createTestSuiteType() {
        TestSuiteType testSuiteType = new TestSuiteType();
        return testSuiteType;
    }

    public TestCaseType createTestCaseType() {
        TestCaseType testCaseType = new TestCaseType();
        return testCaseType;
    }

    public PropertiesType createPropertiesType() {
        PropertiesType propertiesType = new PropertiesType();
        return propertiesType;
    }

    public PropertyType createPropertyType() {
        PropertyType propertyType = new PropertyType();
        return propertyType;
    }

    public ProblemType createProblemType() {
        ProblemType problemType = new ProblemType();
        return problemType;
    }

    public Long createISO8601DateTimeFromString(EDataType eDataType, String initialValue) {
        return (Long)super.createFromString(eDataType, initialValue);
    }

    public String convertISO8601DateTimeToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public String createNameTypeFromString(EDataType eDataType, String initialValue) {
        return (String)XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.TOKEN, initialValue);
    }

    public String convertNameTypeToString(EDataType eDataType, Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.TOKEN, instanceValue);
    }

    public Double createTimeFromString(EDataType eDataType, String initialValue) {
        return initialValue == null ? null : Double.valueOf(Double.parseDouble(initialValue));
    }

    public String convertTimeToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue == null) {
            return null;
        }
        DecimalFormat decimalFormat = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        decimalFormat.setMaximumFractionDigits(6);
        return decimalFormat.format(instanceValue);
    }

    public JUnitPackage getJUnitPackage() {
        return (JUnitPackage)this.getEPackage();
    }
}

