/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsch.internal.ui.authenticator;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jsch.internal.ui.JSchUIPlugin;
import org.eclipse.jsch.internal.ui.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class KeyboardInteractiveDialog
extends TrayDialog {
    protected boolean isUsernameMutable = false;
    private Text[] texts;
    protected Image keyLockImage;
    protected Button allowCachingButton;
    protected Text usernameField;
    protected String defaultUsername;
    protected String comment;
    protected String destination;
    protected String name;
    protected String instruction;
    protected String lang;
    protected String[] prompt;
    protected boolean[] echo;
    private String message;
    private String[] result;
    protected boolean allowCaching = false;
    private boolean isPasswordAuth = false;

    public KeyboardInteractiveDialog(Shell parentShell, String comment, String destination, String name, String userName, String instruction, String[] prompt, boolean[] echo) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.comment = comment;
        this.destination = destination;
        this.name = name;
        this.defaultUsername = userName;
        this.instruction = instruction;
        this.prompt = prompt;
        this.echo = echo;
        this.message = NLS.bind((String)Messages.KeyboradInteractiveDialog_message, (Object[])new String[]{String.valueOf(destination) + (name != null && name.length() > 0 ? ": " + name : "")});
        if (prompt != null && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
            this.isPasswordAuth = true;
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.isPasswordAuth) {
            newShell.setText(Messages.UserValidationDialog_required);
        } else {
            newShell.setText(this.message);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.jsch.ui.keyboard_interactive_dialog_context");
    }

    public void create() {
        super.create();
        if (this.isPasswordAuth && this.usernameField != null) {
            this.usernameField.setText(this.defaultUsername);
            this.usernameField.setEditable(false);
        }
        if (this.texts.length > 0) {
            this.texts[0].setFocus();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Label label;
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(768));
        Composite imageComposite = new Composite(top, 0);
        layout = new GridLayout();
        imageComposite.setLayout((Layout)layout);
        imageComposite.setLayoutData((Object)new GridData(1040));
        Composite main = new Composite(top, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(768));
        Label imageLabel = new Label(imageComposite, 0);
        this.keyLockImage = JSchUIPlugin.getImageDescriptor("wizban/keylock.gif").createImage();
        imageLabel.setImage(this.keyLockImage);
        GridData data = new GridData(768);
        imageLabel.setLayoutData((Object)data);
        if (this.message != null) {
            Label messageLabel = new Label(main, 64);
            messageLabel.setText(this.message);
            data = new GridData(768);
            data.horizontalSpan = 3;
            data.widthHint = 400;
            messageLabel.setLayoutData((Object)data);
        }
        if (this.comment != null) {
            label = new Label(main, 64);
            if (this.isUsernameMutable) {
                label.setText(NLS.bind((String)Messages.UserValidationDialog_labelUser, (Object[])new String[]{this.comment}));
            } else {
                label.setText(NLS.bind((String)Messages.UserValidationDialog_labelPassword, (Object[])new Object[]{this.defaultUsername, this.comment}));
            }
            data = new GridData(768);
            data.horizontalSpan = 3;
            data.widthHint = 400;
            label.setLayoutData((Object)data);
        }
        if (this.instruction != null && this.instruction.length() > 0) {
            label = new Label(main, 64);
            label.setText(this.instruction);
            data = new GridData(768);
            data.horizontalSpan = 3;
            data.widthHint = 400;
            label.setLayoutData((Object)data);
        }
        if (this.isPasswordAuth) {
            this.createUsernameFields(main);
        }
        this.createPasswordFields(main);
        if (this.isPasswordAuth) {
            this.allowCachingButton = new Button(main, 32);
            this.allowCachingButton.setText(Messages.UserValidationDialog_6);
            data = new GridData(768);
            data.horizontalSpan = 3;
            this.allowCachingButton.setLayoutData((Object)data);
            this.allowCachingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    KeyboardInteractiveDialog.this.allowCaching = KeyboardInteractiveDialog.this.allowCachingButton.getSelection();
                }
            });
        }
        Dialog.applyDialogFont((Control)parent);
        return main;
    }

    protected void createUsernameFields(Composite parent) {
        new Label(parent, 0).setText(Messages.UserValidationDialog_user);
        this.usernameField = new Text(parent, 2048);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.usernameField.setLayoutData((Object)data);
    }

    protected void createPasswordFields(Composite parent) {
        this.texts = new Text[this.prompt.length];
        int i = 0;
        while (i < this.prompt.length) {
            new Label(parent, 0).setText(this.prompt[i]);
            int flag = 2048;
            if (!this.echo[i]) {
                flag |= 0x400000;
            }
            this.texts[i] = new Text(parent, flag);
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            data.widthHint = this.convertHorizontalDLUsToPixels(200);
            this.texts[i].setLayoutData((Object)data);
            if (!this.echo[i]) {
                this.texts[i].setEchoChar('*');
            }
            ++i;
        }
    }

    public String[] getResult() {
        return this.result;
    }

    public boolean getAllowCaching() {
        return this.allowCaching;
    }

    protected void okPressed() {
        this.result = new String[this.prompt.length];
        int i = 0;
        while (i < this.texts.length) {
            this.result[i] = this.texts[i].getText();
            ++i;
        }
        super.okPressed();
    }

    public void setUsernameMutable(boolean value) {
        this.isUsernameMutable = value;
    }

    protected void cancelPressed() {
        this.result = null;
        super.cancelPressed();
    }

    public boolean close() {
        if (this.keyLockImage != null) {
            this.keyLockImage.dispose();
        }
        return super.close();
    }
}

