/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.console.core.util;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.setup.AttributeRule;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.VariableTask;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.util.OS;

public class ScopeAdjuster {
    private static final URI WORKSPACE_LOCATION_ATTRIBUTE_URI = SetupTaskPerformer.getAttributeURI((EAttribute)SetupPackage.Literals.WORKSPACE_TASK__LOCATION);
    private static final URI INSTALLATION_LOCATION_ATTRIBUTE_URI = SetupTaskPerformer.getAttributeURI((EAttribute)SetupPackage.Literals.INSTALLATION_TASK__LOCATION);
    private static final URI INSTALLATION_RELATIVE_PRODUCT_FOLDER_ATTRIBUTE_URI = SetupTaskPerformer.getAttributeURI((EAttribute)SetupPackage.Literals.INSTALLATION_TASK__RELATIVE_PRODUCT_FOLDER);

    public void setWorkspaceLacation(User user, String workspaceDir) {
        ScopeAdjuster.setPreferredAttributeRule((EList<AttributeRule>)user.getAttributeRules(), WORKSPACE_LOCATION_ATTRIBUTE_URI, workspaceDir);
        this.setPreferredVariable(user, "workspace.location", workspaceDir);
    }

    public void setInstallationLocation(User user, String installDir) {
        ScopeAdjuster.setPreferredAttributeRule((EList<AttributeRule>)user.getAttributeRules(), INSTALLATION_LOCATION_ATTRIBUTE_URI, installDir);
        this.setPreferredVariable(user, "installation.location", installDir);
        this.setPreferredVariable(user, "install.root", installDir);
    }

    public void setProductFolderName(User user, String folderName) {
        ScopeAdjuster.setPreferredAttributeRule((EList<AttributeRule>)user.getAttributeRules(), INSTALLATION_RELATIVE_PRODUCT_FOLDER_ATTRIBUTE_URI, folderName);
        this.setPreferredVariable(user, "installation.id", folderName);
    }

    public void setProductFolderName(ProductVersion scope, String folderName) {
        String osgiOS = OS.INSTANCE.getOsgiOS();
        String osgiWS = OS.INSTANCE.getOsgiWS();
        String osgiArch = OS.INSTANCE.getOsgiArch();
        String[] keys = new String[]{"folderName." + osgiOS + "." + osgiWS + "." + osgiArch, "folderName." + osgiOS + "." + osgiWS, "folderName." + osgiOS, "folderName"};
        this.setProductFolderName((Scope)scope, folderName, keys);
    }

    private void setProductFolderName(Scope scope, String value, String[] keys) {
        if (scope == null || value == null) {
            return;
        }
        Annotation annotation = scope.getAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo");
        if (annotation != null) {
            EMap details = annotation.getDetails();
            int i = 0;
            while (i <= keys.length - 1) {
                String key = keys[i];
                if (details.get((Object)key) != null) {
                    details.put((Object)key, (Object)value);
                    return;
                }
                details.put((Object)key, (Object)value);
                ++i;
            }
        }
        this.setProductFolderName(scope.getParentScope(), value, keys);
    }

    public static void setPreferredAttributeRule(EList<AttributeRule> attributeRules, URI uri, String value) {
        AttributeRule attributeRule2;
        if (value == null) {
            return;
        }
        for (AttributeRule attributeRule2 : attributeRules) {
            if (!uri.equals(attributeRule2.getAttributeURI())) continue;
            attributeRule2.setValue(value);
            return;
        }
        attributeRule2 = SetupFactory.eINSTANCE.createAttributeRule();
        attributeRule2.setAttributeURI(uri);
        attributeRule2.setValue(value);
        attributeRules.add((Object)attributeRule2);
    }

    public void setPreferredVariable(User user, String name, String value) {
        ScopeAdjuster.setPreferredVariable((List<? extends SetupTask>)user.getSetupTasks(), name, value);
    }

    public static void setPreferredVariable(List<? extends SetupTask> tasks, String name, String value) {
        if (value == null) {
            return;
        }
        for (SetupTask setupTask : tasks) {
            VariableTask variable;
            if (!(setupTask instanceof VariableTask) || !name.equals((variable = (VariableTask)setupTask).getName())) continue;
            variable.setValue(value);
            return;
        }
        VariableTask variableTask = SetupFactory.eINSTANCE.createVariableTask();
        variableTask.setName(name);
        variableTask.setValue(value);
        tasks.add((SetupTask)variableTask);
    }

    public void setPreferredVariablesFromProperty(List<? extends SetupTask> tasks) {
        for (SetupTask setupTask : tasks) {
            VariableTask variable;
            String value;
            if (!(setupTask instanceof VariableTask) || (value = System.getProperty((variable = (VariableTask)setupTask).getName())) == null) continue;
            variable.setValue(value);
        }
    }
}

