/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.console.core.application;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.HashSet;
import java.util.Set;

public class FilePermissionVisitor
extends SimpleFileVisitor<Path> {
    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.isUserOwnerOf(dir)) {
            Set<PosixFilePermission> perms = this.getPropagatedOwnerPermissions(Files.getPosixFilePermissions(dir, new LinkOption[0]));
            Files.setPosixFilePermissions(dir, perms);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (this.isUserOwnerOf(file)) {
            Set<PosixFilePermission> perms = this.getPropagatedOwnerPermissions(Files.getPosixFilePermissions(file, new LinkOption[0]));
            Files.setPosixFilePermissions(file, perms);
        }
        return FileVisitResult.CONTINUE;
    }

    private boolean isUserOwnerOf(Path dir) throws IOException {
        FileOwnerAttributeView ownerAttributeView = Files.getFileAttributeView(dir, FileOwnerAttributeView.class, new LinkOption[0]);
        UserPrincipal owner = ownerAttributeView.getOwner();
        return owner.getName().equals(System.getProperty("user.name"));
    }

    private Set<PosixFilePermission> getPropagatedOwnerPermissions(Set<PosixFilePermission> currentPermissions) {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        if (currentPermissions.contains((Object)PosixFilePermission.OWNER_READ)) {
            perms.add(PosixFilePermission.OWNER_READ);
            perms.add(PosixFilePermission.OTHERS_READ);
            perms.add(PosixFilePermission.GROUP_READ);
        }
        if (currentPermissions.contains((Object)PosixFilePermission.OWNER_WRITE)) {
            perms.add(PosixFilePermission.OWNER_WRITE);
            perms.add(PosixFilePermission.GROUP_WRITE);
        }
        if (currentPermissions.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
            perms.add(PosixFilePermission.GROUP_EXECUTE);
        }
        return perms;
    }
}

