/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.console.core.application;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.repository.Activator;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.oomph.console.core.application.FilePermissionVisitor;
import org.eclipse.oomph.console.core.p2.P2ServiceUI;
import org.eclipse.oomph.console.core.parameters.Parameters;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.BundlePool;
import org.eclipse.oomph.p2.core.P2Util;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public abstract class AbstractLauncherApplication
implements IApplication {
    public Object start(IApplicationContext context) throws Exception {
        List<String> list = Arrays.asList(Platform.getCommandLineArgs());
        if (list.contains("-version")) {
            Version v = Platform.getProduct().getDefiningBundle().getVersion();
            String semVer = String.format("%d.%d.%d+%s", v.getMajor(), v.getMinor(), v.getMicro(), v.getQualifier());
            System.out.println("Version: " + semVer);
            return EXIT_OK;
        }
        P2Util.getCurrentProvisioningAgent().registerService(UIServices.SERVICE_NAME, (Object)P2ServiceUI.SERVICE_UI);
        IProvisioningAgent agent = (IProvisioningAgent)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)IProvisioningAgent.SERVICE_NAME);
        agent.registerService(UIServices.SERVICE_NAME, (Object)P2ServiceUI.SERVICE_UI);
        this.initBundlePool();
        this.setSharedBundlePoolPermissions(Parameters.SETUP_P2_AGENT);
        this.run();
        this.setSharedBundlePoolPermissions(Parameters.SETUP_P2_AGENT);
        return null;
    }

    public abstract void run() throws Exception;

    private void initBundlePool() {
        String customBundlePoolLocation = Parameters.SETUP_P2_AGENT;
        BundlePool pool = null;
        if (customBundlePoolLocation != null && (pool = P2Util.getAgentManager().getBundlePool(new File(customBundlePoolLocation))) == null) {
            Agent agent = P2Util.getAgentManager().addAgent(new File(customBundlePoolLocation));
            pool = agent.addBundlePool(new File(customBundlePoolLocation, "pool"));
            P2Util.getAgentManager().setDefaultBundlePool("org.eclipse.oomph.console.core", pool);
        }
        this.setCurrentBundlePool(pool);
    }

    private void setCurrentBundlePool(BundlePool pool) {
        if (pool != null) {
            P2Util.getAgentManager().setDefaultBundlePool("org.eclipse.oomph.console.core", pool);
            System.setProperty("oomph.p2.pool", pool.getLocation().getAbsolutePath());
        } else {
            System.clearProperty("oomph.p2.pool");
        }
    }

    public void stop() {
    }

    private void setSharedBundlePoolPermissions(String location) {
        if (location == null) {
            return;
        }
        try {
            Files.walkFileTree(Paths.get(location, new String[0]), new FilePermissionVisitor());
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }
}

